/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.gui;

import java.util.ArrayList;
import java.util.Random;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import lindenmayer.parser.WordConstant;

public class Derivation
extends Thread
implements ListModel {
    EventListenerList listeners = new EventListenerList();
    lindenmayer.parser.System system;
    ArrayList derivation;
    Random random;
    boolean running = true;
    int maxDepth;
    int maxWordSize;
    static Class class$javax$swing$event$ListDataListener;

    public Derivation(lindenmayer.parser.System system, int maxDepth, int maxWordSize, Random random) {
        this.setDaemon(true);
        this.setPriority(1);
        this.system = system;
        this.maxDepth = maxDepth;
        this.maxWordSize = maxWordSize;
        this.random = random;
        this.derivation = new ArrayList();
    }

    public void addListDataListener(ListDataListener listener) {
        this.listeners.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = Derivation.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.listeners.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = Derivation.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listener);
    }

    public int getSize() {
        return this.derivation.size();
    }

    public Object getElementAt(int index) {
        return this.derivation.get(index);
    }

    void fireIntervalAdded(Object source, int s, int e) {
        ListDataListener[] l = (ListDataListener[])this.listeners.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = Derivation.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
        for (int i = 0; i < l.length; ++i) {
            l[i].intervalAdded(new ListDataEvent(source, 1, s, e));
        }
    }

    void fireIntervalRemoved(Object source, int s, int e) {
        ListDataListener[] l = (ListDataListener[])this.listeners.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = Derivation.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
        for (int i = 0; i < l.length; ++i) {
            l[i].intervalRemoved(new ListDataEvent(source, 2, s, e));
        }
    }

    void append(WordConstant word) {
        int size = this.derivation.size();
        this.derivation.add(word);
        this.fireIntervalAdded(this, size, size + 1);
    }

    public void run() {
        int size1;
        int depth = 0;
        int size0 = this.derivation.size();
        long t0 = System.currentTimeMillis();
        try {
            WordConstant w = this.system.getAxiom();
            while (this.running) {
                int s;
                this.derivation.add(w);
                w = this.system.deriveRandomly(w, this.random, depth + 1);
                long t1 = System.currentTimeMillis();
                if (t1 - t0 > (long)1000) {
                    size1 = this.derivation.size();
                    if (size1 > size0) {
                        this.fireIntervalAdded(this, size0, size1);
                    }
                    size0 = size1;
                    t0 = t1;
                }
                if ((s = w.size()) > this.maxWordSize || s <= 0) {
                    this.running = false;
                }
                if (++depth <= this.maxDepth) continue;
                this.running = false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if ((size1 = this.derivation.size()) > size0) {
            this.fireIntervalAdded(this, size0, size1);
        }
        System.out.println("Derivation stopped.");
    }

    public void performStart() {
        this.start();
    }

    public void performStop() {
        this.running = false;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

