/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lindenmayer.gui.Derivation;
import lindenmayer.parser.LindenmayerLexer;
import lindenmayer.parser.LindenmayerParser;
import lindenmayer.parser.WordConstant;
import lindenmayer.turtle2d.Turtle2D;
import lindenmayer.turtle3d.Turtle3D;

public class Project {
    public static final String APPLICATION_TITLE = "0L";
    public static final String DEFAULT_SOURCE_CODE = "";
    private static int openWindowCount;
    WindowListener frameListener = new WindowAdapter(this){

        public void windowClosed(WindowEvent e) {
            --openWindowCount;
            if (openWindowCount <= 0) {
                System.exit(0);
            }
        }
    };
    ListSelectionListener derivationListListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent event) {
            WordConstant word = (WordConstant)Project.this.derivationList.getSelectedValue();
            if (word != null) {
                Project.this.wordText.setText(word.toFullyString());
            } else {
                Project.this.wordText.setText(Project.DEFAULT_SOURCE_CODE);
            }
        }
    };
    ActionListener interpretListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            block6: {
                WordConstant word = (WordConstant)Project.this.derivationList.getSelectedValue();
                if (word != null && Project.this.system != null) {
                    try {
                        String interpreter = Project.this.system.getInterpretation().getInterpreter();
                        if (interpreter == null) {
                            throw new NullPointerException("Fatal: interpreter == null");
                        }
                        if (interpreter.equals("turtle2d")) {
                            Turtle2D turtle2d = new Turtle2D();
                            turtle2d.init();
                            Project.this.system.interpret(word, turtle2d);
                            turtle2d.compile();
                            break block6;
                        }
                        if (interpreter.equals("turtle3d")) {
                            Runtime.getRuntime().gc();
                            Turtle3D turtle3d = new Turtle3D();
                            turtle3d.init();
                            Project.this.system.interpret(word, turtle3d);
                            turtle3d.compile();
                            Runtime.getRuntime().gc();
                            turtle3d.show();
                            break block6;
                        }
                        throw new IllegalStateException("Fatal: unknown interpreter: ".concat(String.valueOf(String.valueOf(interpreter))));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(Project.this.frame, e, "Parsing Error", 0);
                    }
                }
            }
        }
    };
    ActionListener startDerivationListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            if (Project.this.derivation != null) {
                Project.this.derivation.performStop();
            }
            try {
                long seed;
                int maxWordSize;
                int maxDepth;
                try {
                    maxDepth = Integer.parseInt(Project.this.maxDepthText.getText());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(Project.this.frame, e.getMessage(), "Error in Maximal Depth", 0);
                    return;
                }
                try {
                    maxWordSize = Integer.parseInt(Project.this.maxWordSizeText.getText());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(Project.this.frame, e.getMessage(), "Error in Maximal Word Length", 0);
                    return;
                }
                if (Project.this.seedRandomCheck.getModel().isSelected()) {
                    seed = System.currentTimeMillis();
                    Project.this.seedText.setText(String.valueOf(seed));
                } else {
                    try {
                        seed = Long.parseLong(Project.this.seedText.getText());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(Project.this.frame, e.getMessage(), "Error in Seed", 0);
                        return;
                    }
                }
                LindenmayerLexer l = new LindenmayerLexer(new StringReader(Project.this.editorText.getText()));
                LindenmayerParser p = new LindenmayerParser(l);
                Project.this.system = p.definition_system();
                Project.this.derivation = new Derivation(Project.this.system, maxDepth, maxWordSize, new Random(seed));
                Project.this.derivation.performStart();
                Project.this.derivationList.setModel(Project.this.derivation);
                Project.this.tabbedPane.setSelectedComponent(Project.this.derivationPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Project.this.frame, e, "Parsing Error", 0);
            }
        }
    };
    ActionListener stopDerivationListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            if (Project.this.derivation != null) {
                Project.this.derivation.performStop();
            }
        }
    };
    ActionListener projectNewListener = new ActionListener(this){

        public void actionPerformed(ActionEvent event) {
            new Project();
        }
    };
    ActionListener projectLoadListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            try {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(Project.this.frame) == 0) {
                    if (Project.this.projectPath == null && Project.this.editorText.getText().length() == 0) {
                        Project.this.loadProject(chooser.getSelectedFile());
                    } else {
                        Project.createProject(chooser.getSelectedFile());
                    }
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Project.this.frame, e.getMessage(), "Error Opening Project", 0);
            }
        }
    };
    ActionListener projectSaveListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            try {
                if (Project.this.projectPath != null) {
                    Project.this.saveProjectAs(Project.this.projectPath);
                } else {
                    JFileChooser chooser = new JFileChooser();
                    if (chooser.showSaveDialog(Project.this.frame) == 0) {
                        if (chooser.getSelectedFile().isFile()) {
                            if (JOptionPane.showConfirmDialog(Project.this.frame, String.valueOf(String.valueOf(new StringBuffer("Overwrite file ").append(chooser.getSelectedFile().getName()).append("?"))), "Saving Project", 2) == 0) {
                                Project.this.saveProjectAs(chooser.getSelectedFile());
                            }
                        } else {
                            Project.this.saveProjectAs(chooser.getSelectedFile());
                        }
                    }
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Project.this.frame, e.getMessage(), "Error Saving Project", 0);
            }
        }
    };
    ActionListener projectSaveAsListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            try {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showSaveDialog(Project.this.frame) == 0) {
                    if (chooser.getSelectedFile().isFile()) {
                        if (JOptionPane.showConfirmDialog(Project.this.frame, String.valueOf(String.valueOf(new StringBuffer("Overwrite file ").append(chooser.getSelectedFile().getName()).append("?"))), "Saving Project", 2) == 0) {
                            Project.this.saveProjectAs(chooser.getSelectedFile());
                        }
                    } else {
                        Project.this.saveProjectAs(chooser.getSelectedFile());
                    }
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Project.this.frame, e.getMessage(), "Error Saving Project", 0);
            }
        }
    };
    String projectName = "untitled";
    File projectPath = null;
    lindenmayer.parser.System system;
    Derivation derivation = null;
    JTextArea editorText;
    JScrollPane editorScrollPane;
    BorderLayout editorLayout;
    JPanel editorPanel;
    JList derivationList;
    JScrollPane derivationScrollPane;
    BorderLayout derivationLayout;
    JPanel derivationPanel;
    JTextArea wordText;
    JScrollPane wordScrollPane;
    BorderLayout wordLayout;
    JPanel wordPanel;
    JLabel seedLabel;
    JTextField seedText;
    JCheckBox seedRandomCheck;
    JLabel maxDepthLabel;
    JTextField maxDepthText;
    JLabel maxWordSizeLabel;
    JTextField maxWordSizeText;
    JButton startDerivationButton;
    JButton stopDerivationButton;
    JButton interpretButton;
    GridLayout controlLayout;
    JPanel controlPanel;
    JMenuBar menuBar;
    JMenu projectMenu;
    JMenuItem projectNewItem;
    JMenuItem projectLoadItem;
    JMenuItem projectSaveItem;
    JMenuItem projectSaveAsItem;
    JPanel rightPanel;
    JTabbedPane tabbedPane;
    BorderLayout frameLayout;
    JFrame frame;

    public Project() {
        ++openWindowCount;
        this.editorText = new JTextArea();
        this.editorText.setText(DEFAULT_SOURCE_CODE);
        this.editorScrollPane = new JScrollPane();
        this.editorScrollPane.getViewport().add(this.editorText);
        this.editorLayout = new BorderLayout();
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(this.editorLayout);
        this.editorPanel.add((Component)this.editorScrollPane, "Center");
        this.derivationList = new JList();
        this.derivationList.addListSelectionListener(this.derivationListListener);
        this.derivationScrollPane = new JScrollPane();
        this.derivationScrollPane.getViewport().add(this.derivationList);
        this.derivationPanel = new JPanel();
        this.derivationLayout = new BorderLayout();
        this.derivationPanel.setLayout(this.derivationLayout);
        this.derivationPanel.add((Component)this.derivationScrollPane, "Center");
        this.wordText = new JTextArea();
        this.wordText.setEditable(false);
        this.wordScrollPane = new JScrollPane();
        this.wordScrollPane.getViewport().add(this.wordText);
        this.wordLayout = new BorderLayout();
        this.wordPanel = new JPanel();
        this.wordPanel.setLayout(this.wordLayout);
        this.wordPanel.add((Component)this.wordScrollPane, "Center");
        this.seedLabel = new JLabel("Seed for randomizer");
        this.seedText = new JTextField(String.valueOf(System.currentTimeMillis()));
        this.seedRandomCheck = new JCheckBox("Random seed", true);
        this.maxDepthLabel = new JLabel("Maximal depth:");
        this.maxDepthText = new JTextField("100");
        this.maxWordSizeLabel = new JLabel("Maximal word length:");
        this.maxWordSizeText = new JTextField("1000");
        this.startDerivationButton = new JButton("Start Derivation");
        this.startDerivationButton.addActionListener(this.startDerivationListener);
        this.stopDerivationButton = new JButton("Stop Derivation");
        this.stopDerivationButton.addActionListener(this.stopDerivationListener);
        this.interpretButton = new JButton("Interpretation");
        this.interpretButton.addActionListener(this.interpretListener);
        this.controlLayout = new GridLayout(10, 1, 2, 2);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(this.controlLayout);
        this.controlPanel.add(this.seedLabel);
        this.controlPanel.add(this.seedText);
        this.controlPanel.add(this.seedRandomCheck);
        this.controlPanel.add(this.maxDepthLabel);
        this.controlPanel.add(this.maxDepthText);
        this.controlPanel.add(this.maxWordSizeLabel);
        this.controlPanel.add(this.maxWordSizeText);
        this.controlPanel.add(this.startDerivationButton);
        this.controlPanel.add(this.stopDerivationButton);
        this.controlPanel.add(this.interpretButton);
        this.rightPanel = new JPanel();
        this.rightPanel.add(this.controlPanel);
        this.projectNewItem = new JMenuItem("New Window");
        this.projectNewItem.addActionListener(this.projectNewListener);
        this.projectLoadItem = new JMenuItem("Open...");
        this.projectLoadItem.addActionListener(this.projectLoadListener);
        this.projectSaveItem = new JMenuItem("Save");
        this.projectSaveItem.addActionListener(this.projectSaveListener);
        this.projectSaveAsItem = new JMenuItem("Save As...");
        this.projectSaveAsItem.addActionListener(this.projectSaveAsListener);
        this.projectMenu = new JMenu("Project");
        this.projectMenu.add(this.projectNewItem);
        this.projectMenu.add(this.projectLoadItem);
        this.projectMenu.add(this.projectSaveItem);
        this.projectMenu.add(this.projectSaveAsItem);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.projectMenu);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.editorPanel, "Editor");
        this.tabbedPane.add((Component)this.derivationPanel, "Derivation");
        this.tabbedPane.add((Component)this.wordPanel, "Selected Word");
        this.frameLayout = new BorderLayout();
        this.frame = new JFrame("0L - ".concat(String.valueOf(String.valueOf(this.projectName))));
        this.frame.addWindowListener(this.frameListener);
        this.frame.getContentPane().setLayout(this.frameLayout);
        this.frame.setJMenuBar(this.menuBar);
        this.frame.getContentPane().add((Component)this.tabbedPane, "Center");
        this.frame.getContentPane().add((Component)this.rightPanel, "East");
        this.frame.setDefaultCloseOperation(2);
        ((Component)this.frame).setSize(800, 600);
        ((Component)this.frame).setVisible(true);
    }

    public void setProjectPath(File path) {
        this.projectPath = path;
        this.projectName = path.getName();
        this.frame.setTitle("0L - ".concat(String.valueOf(String.valueOf(this.projectName))));
    }

    public void saveProjectAs(File path) throws IOException {
        FileWriter out = new FileWriter(path);
        out.write(this.editorText.getText());
        ((Writer)out).close();
        this.setProjectPath(path);
    }

    public void loadProject(File path) throws IOException {
        int read;
        StringBuffer text = new StringBuffer();
        char[] buffer = new char[4096];
        FileReader in = new FileReader(path);
        while ((read = in.read(buffer)) > 0) {
            text.append(buffer, 0, read);
        }
        this.setProjectPath(path);
        this.editorText.setText(text.toString());
    }

    public static Project createProject(File path) throws IOException {
        int read;
        StringBuffer text = new StringBuffer();
        char[] buffer = new char[4096];
        FileReader in = new FileReader(path);
        while ((read = in.read(buffer)) > 0) {
            text.append(buffer, 0, read);
        }
        Project p = new Project();
        p.setProjectPath(path);
        p.editorText.setText(text.toString());
        return p;
    }

    public static void main(String[] args) {
        Project project1 = new Project();
    }

    static {
        APPLICATION_TITLE = APPLICATION_TITLE;
        DEFAULT_SOURCE_CODE = DEFAULT_SOURCE_CODE;
        openWindowCount = 0;
    }
}

