/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.Map;
import lindenmayer.parser.ExpressionArithmetic;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.UnknownMethodException;
import lindenmayer.parser.WrongSignatureException;

public class Function
extends ExpressionArithmetic {
    String id;
    ExpressionArithmetic[] arguments;

    public Function(String id, ExpressionArithmetic[] arguments) {
        this.id = id;
        this.arguments = arguments;
    }

    public void assignVariables(Map variableIdMap) throws UndefinedVariableException {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].assignVariables(variableIdMap);
        }
    }

    public void assignMethods(Map methodMap) throws WrongSignatureException, UnknownMethodException {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].assignMethods(methodMap);
        }
    }

    public double evaluateDouble() {
        return 0.0;
    }

    public String toString() {
        String result = String.valueOf(String.valueOf(this.id)).concat("(");
        if (this.arguments.length > 0) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(this.arguments[0].toString())));
        }
        for (int i = 1; i < this.arguments.length; ++i) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(", ".concat(String.valueOf(String.valueOf(this.arguments[i].toString()))))));
        }
        result = String.valueOf(String.valueOf(result)).concat(")");
        return result;
    }
}

