/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.LinkedList;
import lindenmayer.parser.Addition;
import lindenmayer.parser.Assignment;
import lindenmayer.parser.Conjunction;
import lindenmayer.parser.ConstantDefinition;
import lindenmayer.parser.Disjunction;
import lindenmayer.parser.Division;
import lindenmayer.parser.Equal;
import lindenmayer.parser.ExpressionArithmetic;
import lindenmayer.parser.ExpressionBoolean;
import lindenmayer.parser.False;
import lindenmayer.parser.Function;
import lindenmayer.parser.GreaterOrEqual;
import lindenmayer.parser.GreaterThan;
import lindenmayer.parser.Interpretation;
import lindenmayer.parser.LessOrEqual;
import lindenmayer.parser.LessThan;
import lindenmayer.parser.Limitation;
import lindenmayer.parser.LimitationNone;
import lindenmayer.parser.LimitationUnary;
import lindenmayer.parser.LimitationUniformly;
import lindenmayer.parser.LindenmayerParserTokenTypes;
import lindenmayer.parser.MethodCall;
import lindenmayer.parser.Multiplication;
import lindenmayer.parser.Negation;
import lindenmayer.parser.NumberDouble;
import lindenmayer.parser.Reference;
import lindenmayer.parser.Rule;
import lindenmayer.parser.Statement;
import lindenmayer.parser.Substitution;
import lindenmayer.parser.Subtraction;
import lindenmayer.parser.SymbolConstant;
import lindenmayer.parser.SymbolDefinition;
import lindenmayer.parser.SymbolExpression;
import lindenmayer.parser.SymbolInterpretation;
import lindenmayer.parser.SymbolVariable;
import lindenmayer.parser.SymbolsDefinition;
import lindenmayer.parser.System;
import lindenmayer.parser.Table;
import lindenmayer.parser.True;
import lindenmayer.parser.Unequal;
import lindenmayer.parser.Variable;
import lindenmayer.parser.WordConstant;
import lindenmayer.parser.WordExpression;
import lindenmayer.parser.WordVariable;

public class LindenmayerParser
extends LLkParser
implements LindenmayerParserTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "'='", "'('", "';'", "')'", "':'", "','", "'<'", "'>'", "'|'", "'+='", "'-='", "'*='", "'/='", "'or'", "'and'", "'not'", "TRUE", "FALSE", "'=='", "'=='", "'<='", "'>='", "'+'", "'-'", "'*'", "'/'", "a literal", "'|'", "a digit", "SPECIALSYMBOL", "'.'", "WS_TOKEN", "whitespace", "SL_COMMENT", "ML_COMMENT"};
    private static final long[] _tokenSet_0_data_ = new long[]{0x2CC000000L, 0L};
    public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);
    private static final long[] _tokenSet_1_data_ = new long[]{12012487680L, 0L};
    public static final BitSet _tokenSet_1 = new BitSet(_tokenSet_1_data_);
    private static final long[] _tokenSet_2_data_ = new long[]{7650410528L, 0L};
    public static final BitSet _tokenSet_2 = new BitSet(_tokenSet_2_data_);
    private static final long[] _tokenSet_3_data_ = new long[]{25702694944L, 0L};
    public static final BitSet _tokenSet_3 = new BitSet(_tokenSet_3_data_);
    private static final long[] _tokenSet_4_data_ = new long[]{25698897648L, 0L};
    public static final BitSet _tokenSet_4 = new BitSet(_tokenSet_4_data_);
    private static final long[] _tokenSet_5_data_ = new long[]{7516315664L, 0L};
    public static final BitSet _tokenSet_5 = new BitSet(_tokenSet_5_data_);
    private static final long[] _tokenSet_6_data_ = new long[]{7516192800L, 0L};
    public static final BitSet _tokenSet_6 = new BitSet(_tokenSet_6_data_);
    private static final long[] _tokenSet_7_data_ = new long[]{7654080544L, 0L};
    public static final BitSet _tokenSet_7 = new BitSet(_tokenSet_7_data_);
    private static final long[] _tokenSet_8_data_ = new long[]{25765612576L, 0L};
    public static final BitSet _tokenSet_8 = new BitSet(_tokenSet_8_data_);
    private static final long[] _tokenSet_9_data_ = new long[]{25635586080L, 0L};
    public static final BitSet _tokenSet_9 = new BitSet(_tokenSet_9_data_);
    private static final long[] _tokenSet_10_data_ = new long[]{24960700144L, 0L};
    public static final BitSet _tokenSet_10 = new BitSet(_tokenSet_10_data_);
    private static final long[] _tokenSet_11_data_ = new long[]{8586137296L, 0L};
    public static final BitSet _tokenSet_11 = new BitSet(_tokenSet_11_data_);

    protected LindenmayerParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public LindenmayerParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected LindenmayerParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public LindenmayerParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public LindenmayerParser(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final System definition_system() throws TokenStreamException, RecognitionException {
        System result = new System();
        WordConstant axiom = null;
        String keyword = null;
        SymbolsDefinition symbols = null;
        Substitution substitution = null;
        Table table = null;
        LinkedList tables = new LinkedList();
        Object rule = null;
        LinkedList rules = new LinkedList();
        Interpretation interpretation = null;
        keyword = this.identifier();
        if (!keyword.equals("constants")) {
            throw new SemanticException("keyword.equals(\"constants\")");
        }
        ConstantDefinition constantDefinition = this.definition_constants(result);
        if (this.inputState.guessing == 0) {
            result.setConstantDefinition(constantDefinition);
        }
        if (!(keyword = this.identifier()).equals("symbols")) {
            throw new SemanticException("keyword.equals(\"symbols\")");
        }
        symbols = this.definition_symbols();
        if (this.inputState.guessing == 0) {
            result.setSymbolsDefintion(symbols);
        }
        if (!(keyword = this.identifier()).equals("axiom")) {
            throw new SemanticException("keyword.equals(\"axiom\")");
        }
        axiom = this.definition_axiom(result);
        if (this.inputState.guessing == 0) {
            result.setAxiom(axiom);
        }
        keyword = this.identifier();
        if (this.LA(1) == 4 && this.LA(2) == 5 && keyword.equals("substitution")) {
            substitution = this.definition_substitution(result);
            if (this.inputState.guessing == 0) {
                result.setSubstitution(substitution);
            }
        } else if (this.LA(1) == 4 && this.LA(2) == 5 && keyword.equals("table")) {
            table = this.definition_table(result);
            if (this.inputState.guessing == 0) {
                substitution = new Substitution(null);
                result.setSubstitution(substitution);
                substitution.appendTable(table);
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (!(keyword = this.identifier()).equals("limitation")) {
            throw new SemanticException("keyword.equals(\"limitation\")");
        }
        Limitation limitation = this.definition_limitation(result);
        if (this.inputState.guessing == 0) {
            result.setLimitation(limitation);
        }
        switch (this.LA(1)) {
            case 30: 
            case 31: {
                keyword = this.identifier();
                if (!keyword.equals("interpretation")) {
                    throw new SemanticException("keyword.equals(\"interpretation\")");
                }
                interpretation = this.definition_interpretation(result);
                if (this.inputState.guessing != 0) break;
                result.setInterpretation(interpretation);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(1);
        return result;
    }

    public final String identifier() throws TokenStreamException, RecognitionException {
        Token l0 = null;
        Token l1 = null;
        Token l2 = null;
        Token l3 = null;
        Token l4 = null;
        String result = "";
        switch (this.LA(1)) {
            case 30: {
                l0 = this.LT(1);
                this.match(30);
                if (this.inputState.guessing != 0) break;
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l0.getText())));
                break;
            }
            case 31: {
                l1 = this.LT(1);
                this.match(31);
                if (this.inputState.guessing != 0) break;
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l1.getText())));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block9: while (true) {
            switch (this.LA(1)) {
                case 30: {
                    l2 = this.LT(1);
                    this.match(30);
                    if (this.inputState.guessing != 0) continue block9;
                    result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l2.getText())));
                    continue block9;
                }
                case 32: {
                    l3 = this.LT(1);
                    this.match(32);
                    if (this.inputState.guessing != 0) continue block9;
                    result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l3.getText())));
                    continue block9;
                }
                case 31: {
                    l4 = this.LT(1);
                    this.match(31);
                    if (this.inputState.guessing != 0) continue block9;
                    result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l4.getText())));
                    continue block9;
                }
            }
            break;
        }
        return result;
    }

    public final ConstantDefinition definition_constants(System system) throws TokenStreamException, RecognitionException {
        ConstantDefinition result;
        block1: {
            result = null;
            LinkedList<Variable> variables = new LinkedList<Variable>();
            LinkedList<ExpressionArithmetic> expressions = new LinkedList<ExpressionArithmetic>();
            this.match(4);
            this.match(5);
            while (this.LA(1) == 30 || this.LA(1) == 31) {
                String id = this.identifier();
                this.match(4);
                ExpressionArithmetic expression = this.expression_arithmetic();
                this.match(6);
                if (this.inputState.guessing != 0) continue;
                variables.add(new Variable(id));
                expressions.add(expression);
            }
            this.match(7);
            this.match(6);
            if (this.inputState.guessing != 0) break block1;
            result = new ConstantDefinition(system, variables.toArray(new Variable[variables.size()]), expressions.toArray(new ExpressionArithmetic[expressions.size()]));
        }
        return result;
    }

    public final SymbolsDefinition definition_symbols() throws TokenStreamException, RecognitionException {
        SymbolsDefinition result = null;
        String id = null;
        LinkedList<SymbolDefinition> symbols = new LinkedList<SymbolDefinition>();
        SymbolDefinition symbol = null;
        this.match(4);
        switch (this.LA(1)) {
            case 5: {
                this.match(5);
                switch (this.LA(1)) {
                    case 26: 
                    case 27: 
                    case 30: 
                    case 31: 
                    case 33: {
                        symbol = this.definition_symbol();
                        if (this.inputState.guessing == 0) {
                            symbols.add(symbol);
                        }
                        while (this.LA(1) == 9) {
                            this.match(9);
                            symbol = this.definition_symbol();
                            if (this.inputState.guessing != 0) continue;
                            symbols.add(symbol);
                        }
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(7);
                break;
            }
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                symbol = this.definition_symbol();
                if (this.inputState.guessing == 0) {
                    symbols.add(symbol);
                }
                while (_tokenSet_0.member(this.LA(1))) {
                    symbol = this.definition_symbol();
                    if (this.inputState.guessing != 0) continue;
                    symbols.add(symbol);
                }
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(6);
        if (this.inputState.guessing == 0) {
            result = new SymbolsDefinition(id, symbols.toArray(new SymbolDefinition[symbols.size()]));
        }
        return result;
    }

    public final WordConstant definition_axiom(System system) throws TokenStreamException, RecognitionException {
        WordConstant result = null;
        this.match(4);
        result = this.word_constant(system);
        this.match(6);
        return result;
    }

    public final Substitution definition_substitution(System system) throws TokenStreamException, RecognitionException {
        Substitution result = null;
        String id = null;
        String keyword = null;
        this.match(4);
        if (this.inputState.guessing == 0) {
            result = new Substitution(id);
        }
        this.match(5);
        while (this.LA(1) == 30 || this.LA(1) == 31) {
            keyword = this.identifier();
            if (!keyword.equals("table")) {
                throw new SemanticException("keyword.equals(\"table\")");
            }
            Table table = this.definition_table(system);
            if (this.inputState.guessing != 0) continue;
            result.appendTable(table);
        }
        this.match(7);
        switch (this.LA(1)) {
            case 6: {
                this.match(6);
                break;
            }
            case 30: 
            case 31: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final Table definition_table(System system) throws TokenStreamException, RecognitionException {
        Table result = null;
        String id = null;
        this.match(4);
        if (this.inputState.guessing == 0) {
            result = new Table(id);
        }
        this.match(5);
        while (_tokenSet_1.member(this.LA(1))) {
            Rule rule = this.definition_rule(system);
            if (this.inputState.guessing != 0) continue;
            result.appendRule(rule);
        }
        this.match(7);
        switch (this.LA(1)) {
            case 6: {
                this.match(6);
                break;
            }
            case 7: 
            case 30: 
            case 31: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final Limitation definition_limitation(System system) throws TokenStreamException, RecognitionException {
        Limitation result = null;
        this.match(8);
        String keyword = this.identifier();
        if (this.LA(1) == 4 && _tokenSet_2.member(this.LA(2)) && keyword.equals("normal")) {
            this.match(4);
            ExpressionArithmetic expression = this.expression_arithmetic();
            this.match(6);
            if (this.inputState.guessing == 0) {
                result = new LimitationUnary(expression);
            }
        } else if (this.LA(1) == 4 && _tokenSet_2.member(this.LA(2)) && keyword.equals("uniformly")) {
            this.match(4);
            ExpressionArithmetic expression = this.expression_arithmetic();
            this.match(6);
            if (this.inputState.guessing == 0) {
                result = new LimitationUniformly(expression);
            }
        } else if (this.LA(1) == 6 && keyword.equals("none")) {
            this.match(6);
            if (this.inputState.guessing == 0) {
                result = new LimitationNone();
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return result;
    }

    public final Interpretation definition_interpretation(System system) throws TokenStreamException, RecognitionException {
        Interpretation result;
        block6: {
            result = null;
            String interpreter = null;
            LinkedList<SymbolInterpretation> interpretations = new LinkedList<SymbolInterpretation>();
            this.match(8);
            interpreter = this.identifier();
            if (!interpreter.equals("turtle2d") && !interpreter.equals("turtle3d")) {
                throw new SemanticException("interpreter.equals(\"turtle2d\") || interpreter.equals(\"turtle3d\")");
            }
            this.match(4);
            this.match(5);
            while (_tokenSet_0.member(this.LA(1))) {
                SymbolInterpretation symbolInterpretation = this.symbol_interpretation(system);
                if (this.inputState.guessing != 0) continue;
                interpretations.add(symbolInterpretation);
            }
            this.match(7);
            switch (this.LA(1)) {
                case 6: {
                    this.match(6);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing != 0) break block6;
            result = new Interpretation(null, interpretations.toArray(new SymbolInterpretation[interpretations.size()]), interpreter);
        }
        return result;
    }

    public final ExpressionArithmetic expression_arithmetic() throws TokenStreamException, RecognitionException {
        ExpressionArithmetic result;
        block17: {
            block16: {
                result = null;
                boolean synPredMatched92 = false;
                if (_tokenSet_2.member(this.LA(1)) && _tokenSet_3.member(this.LA(2))) {
                    int _m92 = this.mark();
                    synPredMatched92 = true;
                    ++this.inputState.guessing;
                    try {
                        this.addition_operand();
                        switch (this.LA(1)) {
                            case 26: {
                                this.match(26);
                                break;
                            }
                            case 27: {
                                this.match(27);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                    }
                    catch (RecognitionException pe) {
                        synPredMatched92 = false;
                    }
                    this.rewind(_m92);
                    --this.inputState.guessing;
                }
                if (!synPredMatched92) break block16;
                ExpressionArithmetic o1 = this.addition_operand();
                switch (this.LA(1)) {
                    case 26: {
                        this.match(26);
                        ExpressionArithmetic o2 = this.expression_arithmetic();
                        if (this.inputState.guessing == 0) {
                            result = new Addition(o1, o2);
                        }
                        break block17;
                    }
                    case 27: {
                        this.match(27);
                        ExpressionArithmetic o2 = this.expression_arithmetic();
                        if (this.inputState.guessing == 0) {
                            result = new Subtraction(o1, o2);
                        }
                        break block17;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            if (_tokenSet_2.member(this.LA(1)) && _tokenSet_4.member(this.LA(2))) {
                result = this.addition_operand();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final SymbolDefinition definition_symbol() throws TokenStreamException, RecognitionException {
        SymbolDefinition result = null;
        String keyword = null;
        int parameterCount = 0;
        String id = this.symbol_identifier();
        switch (this.LA(1)) {
            case 5: {
                this.match(5);
                switch (this.LA(1)) {
                    case 30: 
                    case 31: {
                        keyword = this.identifier();
                        if (!keyword.equals("real")) {
                            throw new SemanticException("keyword.equals(\"real\")");
                        }
                        if (this.inputState.guessing == 0) {
                            ++parameterCount;
                        }
                        while (this.LA(1) == 9) {
                            this.match(9);
                            keyword = this.identifier();
                            if (!keyword.equals("real")) {
                                throw new SemanticException("keyword.equals(\"real\")");
                            }
                            if (this.inputState.guessing != 0) continue;
                            ++parameterCount;
                        }
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(7);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            result = new SymbolDefinition(id, parameterCount);
        }
        return result;
    }

    public final String symbol_identifier() throws TokenStreamException, RecognitionException {
        Token l1 = null;
        Token l2 = null;
        Token l3 = null;
        Token l4 = null;
        Token l5 = null;
        Token d = null;
        String result = "";
        switch (this.LA(1)) {
            case 30: {
                l1 = this.LT(1);
                this.match(30);
                if (this.inputState.guessing != 0) break;
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l1.getText())));
                break;
            }
            case 33: {
                l2 = this.LT(1);
                this.match(33);
                if (this.inputState.guessing != 0) break;
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l2.getText())));
                break;
            }
            case 26: {
                l3 = this.LT(1);
                this.match(26);
                if (this.inputState.guessing != 0) break;
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l3.getText())));
                break;
            }
            case 27: {
                l4 = this.LT(1);
                this.match(27);
                if (this.inputState.guessing != 0) break;
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l4.getText())));
                break;
            }
            case 31: {
                l5 = this.LT(1);
                this.match(31);
                if (this.inputState.guessing != 0) break;
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(l5.getText())));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (this.LA(1) == 32) {
            d = this.LT(1);
            this.match(32);
            if (this.inputState.guessing != 0) continue;
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(d.getText())));
        }
        return result;
    }

    public final WordConstant word_constant(System system) throws TokenStreamException, RecognitionException {
        WordConstant result;
        block1: {
            result = null;
            LinkedList<SymbolConstant> symbols = new LinkedList<SymbolConstant>();
            while (_tokenSet_0.member(this.LA(1))) {
                SymbolConstant symbol = this.symbol_constant(system);
                if (this.inputState.guessing != 0) continue;
                symbols.add(symbol);
            }
            if (this.inputState.guessing != 0) break block1;
            result = new WordConstant(symbols.toArray(new SymbolConstant[symbols.size()]));
        }
        return result;
    }

    public final Rule definition_rule(System system) throws TokenStreamException, RecognitionException {
        Rule result = null;
        WordVariable leftContext = null;
        WordVariable rightContext = null;
        SymbolVariable symbol = null;
        ExpressionBoolean condition = null;
        WordExpression substitute = null;
        switch (this.LA(1)) {
            case 10: {
                this.match(10);
                leftContext = this.word_variable(system);
                this.match(11);
                break;
            }
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        symbol = this.symbol_variable(system);
        switch (this.LA(1)) {
            case 10: {
                this.match(10);
                rightContext = this.word_variable(system);
                this.match(11);
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 12: {
                this.match(12);
                condition = this.expression_boolean();
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(4);
        substitute = this.word_expression(system);
        this.match(6);
        if (this.inputState.guessing == 0) {
            result = new Rule(system, leftContext, rightContext, symbol, condition, substitute);
        }
        return result;
    }

    public final WordVariable word_variable(System system) throws TokenStreamException, RecognitionException {
        WordVariable result;
        block1: {
            result = null;
            LinkedList<SymbolVariable> symbols = new LinkedList<SymbolVariable>();
            while (_tokenSet_0.member(this.LA(1))) {
                SymbolVariable symbol = this.symbol_variable(system);
                if (this.inputState.guessing != 0) continue;
                symbols.add(symbol);
            }
            if (this.inputState.guessing != 0) break block1;
            result = new WordVariable(symbols.toArray(new SymbolVariable[symbols.size()]));
        }
        return result;
    }

    public final SymbolVariable symbol_variable(System system) throws TokenStreamException, RecognitionException {
        SymbolVariable result;
        block10: {
            result = null;
            LinkedList<Variable> parameters = new LinkedList<Variable>();
            String id = this.symbol_identifier();
            switch (this.LA(1)) {
                case 5: {
                    this.match(5);
                    switch (this.LA(1)) {
                        case 30: 
                        case 31: {
                            Variable p1 = this.variable();
                            if (this.inputState.guessing == 0) {
                                parameters.add(p1);
                            }
                            while (this.LA(1) == 9) {
                                this.match(9);
                                Variable p2 = this.variable();
                                if (this.inputState.guessing != 0) continue;
                                parameters.add(p2);
                            }
                            break;
                        }
                        case 7: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(7);
                    break;
                }
                case 4: 
                case 10: 
                case 11: 
                case 12: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 33: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing != 0) break block10;
            result = new SymbolVariable(system.getSymbolDefinitionById(id), parameters.toArray(new Variable[parameters.size()]));
        }
        return result;
    }

    public final ExpressionBoolean expression_boolean() throws TokenStreamException, RecognitionException {
        Disjunction result;
        block2: {
            result = null;
            LinkedList<ExpressionBoolean> operands = new LinkedList<ExpressionBoolean>();
            ExpressionBoolean o1 = this.disjunction_operand();
            if (this.inputState.guessing == 0) {
                operands.add(o1);
            }
            while (this.LA(1) == 17) {
                this.match(17);
                ExpressionBoolean o2 = this.disjunction_operand();
                if (this.inputState.guessing != 0) continue;
                operands.add(o2);
            }
            if (this.inputState.guessing != 0) break block2;
            result = new Disjunction(operands.toArray(new ExpressionBoolean[operands.size()]));
        }
        return result;
    }

    public final WordExpression word_expression(System system) throws TokenStreamException, RecognitionException {
        WordExpression result;
        block1: {
            result = null;
            LinkedList<SymbolExpression> symbols = new LinkedList<SymbolExpression>();
            while (_tokenSet_0.member(this.LA(1))) {
                SymbolExpression symbol = this.symbol_expression(system);
                if (this.inputState.guessing != 0) continue;
                symbols.add(symbol);
            }
            if (this.inputState.guessing != 0) break block1;
            result = new WordExpression(symbols.toArray(new SymbolExpression[symbols.size()]));
        }
        return result;
    }

    public final SymbolConstant symbol_constant(System system) throws TokenStreamException, RecognitionException {
        SymbolConstant result;
        block10: {
            result = null;
            LinkedList<ExpressionArithmetic> parameters = new LinkedList<ExpressionArithmetic>();
            String id = this.symbol_identifier();
            switch (this.LA(1)) {
                case 5: {
                    this.match(5);
                    switch (this.LA(1)) {
                        case 5: 
                        case 27: 
                        case 30: 
                        case 31: 
                        case 32: {
                            ExpressionArithmetic e1 = this.expression_arithmetic();
                            if (this.inputState.guessing == 0) {
                                parameters.add(e1);
                            }
                            while (this.LA(1) == 9) {
                                this.match(9);
                                ExpressionArithmetic e2 = this.expression_arithmetic();
                                if (this.inputState.guessing != 0) continue;
                                parameters.add(e2);
                            }
                            break;
                        }
                        case 7: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(7);
                    break;
                }
                case 6: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 33: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing != 0) break block10;
            result = new SymbolConstant(system, system.getSymbolDefinitionById(id), parameters.toArray(new ExpressionArithmetic[parameters.size()]));
        }
        return result;
    }

    public final Variable variable() throws TokenStreamException, RecognitionException {
        Variable result = null;
        String id = this.identifier();
        if (this.inputState.guessing == 0) {
            result = new Variable(id);
        }
        return result;
    }

    public final SymbolExpression symbol_expression(System system) throws TokenStreamException, RecognitionException {
        SymbolExpression result;
        block10: {
            result = null;
            LinkedList<ExpressionArithmetic> parameters = new LinkedList<ExpressionArithmetic>();
            String id = this.symbol_identifier();
            switch (this.LA(1)) {
                case 5: {
                    this.match(5);
                    switch (this.LA(1)) {
                        case 5: 
                        case 27: 
                        case 30: 
                        case 31: 
                        case 32: {
                            ExpressionArithmetic p1 = this.expression_arithmetic();
                            if (this.inputState.guessing == 0) {
                                parameters.add(p1);
                            }
                            while (this.LA(1) == 9) {
                                this.match(9);
                                ExpressionArithmetic p2 = this.expression_arithmetic();
                                if (this.inputState.guessing != 0) continue;
                                parameters.add(p2);
                            }
                            break;
                        }
                        case 7: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(7);
                    break;
                }
                case 6: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 33: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing != 0) break block10;
            result = new SymbolExpression(system.getSymbolDefinitionById(id), parameters.toArray(new ExpressionArithmetic[parameters.size()]));
        }
        return result;
    }

    public final SymbolInterpretation symbol_interpretation(System system) throws TokenStreamException, RecognitionException {
        SymbolInterpretation result;
        block5: {
            result = null;
            SymbolVariable symbol = null;
            LinkedList<Statement> statements = new LinkedList<Statement>();
            symbol = this.symbol_variable(system);
            this.match(4);
            this.match(5);
            while (this.LA(1) == 30 || this.LA(1) == 31) {
                Statement statement = this.statement();
                if (this.inputState.guessing != 0) continue;
                statements.add(statement);
            }
            this.match(7);
            switch (this.LA(1)) {
                case 6: {
                    this.match(6);
                    break;
                }
                case 7: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 33: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing != 0) break block5;
            result = new SymbolInterpretation(symbol, statements.toArray(new Statement[statements.size()]));
        }
        return result;
    }

    public final Statement statement() throws TokenStreamException, RecognitionException {
        Statement result = null;
        boolean synPredMatched70 = false;
        if ((this.LA(1) == 30 || this.LA(1) == 31) && _tokenSet_5.member(this.LA(2))) {
            int _m70 = this.mark();
            synPredMatched70 = true;
            ++this.inputState.guessing;
            try {
                this.assignment();
            }
            catch (RecognitionException pe) {
                synPredMatched70 = false;
            }
            this.rewind(_m70);
            --this.inputState.guessing;
        }
        if (synPredMatched70) {
            result = this.assignment();
        } else if ((this.LA(1) == 30 || this.LA(1) == 31) && _tokenSet_6.member(this.LA(2))) {
            result = this.method_call();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(6);
        return result;
    }

    public final Assignment assignment() throws TokenStreamException, RecognitionException {
        Assignment result = null;
        ExpressionArithmetic r = null;
        ExpressionArithmetic x = null;
        ExpressionArithmetic y = null;
        r = this.reference();
        switch (this.LA(1)) {
            case 4: {
                this.match(4);
                x = this.expression_arithmetic();
                break;
            }
            case 13: {
                this.match(13);
                y = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                x = new Addition(r, y);
                break;
            }
            case 14: {
                this.match(14);
                y = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                x = new Subtraction(r, y);
                break;
            }
            case 15: {
                this.match(15);
                y = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                x = new Multiplication(r, y);
                break;
            }
            case 16: {
                this.match(16);
                y = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                x = new Division(r, y);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            result = new Assignment((Reference)r, x);
        }
        return result;
    }

    public final MethodCall method_call() throws TokenStreamException, RecognitionException {
        MethodCall result;
        block6: {
            result = null;
            String id = null;
            LinkedList<ExpressionArithmetic> arguments = new LinkedList<ExpressionArithmetic>();
            id = this.identifier();
            this.match(5);
            switch (this.LA(1)) {
                case 5: 
                case 27: 
                case 30: 
                case 31: 
                case 32: {
                    ExpressionArithmetic argument = this.expression_arithmetic();
                    if (this.inputState.guessing == 0) {
                        arguments.add(argument);
                    }
                    while (this.LA(1) == 9) {
                        this.match(9);
                        argument = this.expression_arithmetic();
                        if (this.inputState.guessing != 0) continue;
                        arguments.add(argument);
                    }
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(7);
            if (this.inputState.guessing != 0) break block6;
            result = new MethodCall(id, arguments.toArray(new ExpressionArithmetic[arguments.size()]));
        }
        return result;
    }

    public final ExpressionArithmetic reference() throws TokenStreamException, RecognitionException {
        Reference result = null;
        String id = this.identifier();
        if (this.inputState.guessing == 0) {
            result = new Reference(id);
        }
        return result;
    }

    public final ExpressionBoolean disjunction_operand() throws TokenStreamException, RecognitionException {
        Conjunction result;
        block2: {
            result = null;
            LinkedList<ExpressionBoolean> operands = new LinkedList<ExpressionBoolean>();
            ExpressionBoolean o1 = this.conjunction_operand();
            if (this.inputState.guessing == 0) {
                operands.add(o1);
            }
            while (this.LA(1) == 18) {
                this.match(18);
                ExpressionBoolean o2 = this.conjunction_operand();
                if (this.inputState.guessing != 0) continue;
                operands.add(o2);
            }
            if (this.inputState.guessing != 0) break block2;
            result = new Conjunction(operands.toArray(new ExpressionBoolean[operands.size()]));
        }
        return result;
    }

    public final ExpressionBoolean conjunction_operand() throws TokenStreamException, RecognitionException {
        ExpressionBoolean result = null;
        switch (this.LA(1)) {
            case 19: {
                this.match(19);
                ExpressionBoolean o = this.boolean_operand();
                if (this.inputState.guessing != 0) break;
                result = new Negation(o);
                break;
            }
            case 5: 
            case 20: 
            case 21: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                result = this.boolean_operand();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final ExpressionBoolean boolean_operand() throws TokenStreamException, RecognitionException {
        ExpressionBoolean result = null;
        switch (this.LA(1)) {
            case 20: {
                this.match(20);
                if (this.inputState.guessing != 0) break;
                result = new True();
                break;
            }
            case 21: {
                this.match(21);
                if (this.inputState.guessing != 0) break;
                result = new False();
                break;
            }
            default: {
                boolean synPredMatched86 = false;
                if (this.LA(1) == 5 && _tokenSet_7.member(this.LA(2))) {
                    int _m86 = this.mark();
                    synPredMatched86 = true;
                    ++this.inputState.guessing;
                    try {
                        this.match(5);
                        this.expression_boolean();
                    }
                    catch (RecognitionException pe) {
                        synPredMatched86 = false;
                    }
                    this.rewind(_m86);
                    --this.inputState.guessing;
                }
                if (synPredMatched86) {
                    this.match(5);
                    result = this.expression_boolean();
                    this.match(7);
                    break;
                }
                if (_tokenSet_2.member(this.LA(1)) && _tokenSet_8.member(this.LA(2))) {
                    result = this.comperation();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final ExpressionBoolean comperation() throws TokenStreamException, RecognitionException {
        ExpressionBoolean result = null;
        ExpressionArithmetic e1 = this.expression_arithmetic();
        switch (this.LA(1)) {
            case 22: {
                this.match(22);
                ExpressionArithmetic e2 = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                result = new Equal(e1, e2);
                break;
            }
            case 23: {
                this.match(23);
                ExpressionArithmetic e2 = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                result = new Unequal(e1, e2);
                break;
            }
            case 10: {
                this.match(10);
                ExpressionArithmetic e2 = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                result = new LessThan(e1, e2);
                break;
            }
            case 11: {
                this.match(11);
                ExpressionArithmetic e2 = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                result = new GreaterThan(e1, e2);
                break;
            }
            case 24: {
                this.match(24);
                ExpressionArithmetic e2 = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                result = new LessOrEqual(e1, e2);
                break;
            }
            case 25: {
                this.match(25);
                ExpressionArithmetic e2 = this.expression_arithmetic();
                if (this.inputState.guessing != 0) break;
                result = new GreaterOrEqual(e1, e2);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final ExpressionArithmetic addition_operand() throws TokenStreamException, RecognitionException {
        ExpressionArithmetic result;
        block17: {
            block16: {
                result = null;
                boolean synPredMatched97 = false;
                if (_tokenSet_2.member(this.LA(1)) && _tokenSet_9.member(this.LA(2))) {
                    int _m97 = this.mark();
                    synPredMatched97 = true;
                    ++this.inputState.guessing;
                    try {
                        this.multiplication_operand();
                        switch (this.LA(1)) {
                            case 28: {
                                this.match(28);
                                break;
                            }
                            case 29: {
                                this.match(29);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                    }
                    catch (RecognitionException pe) {
                        synPredMatched97 = false;
                    }
                    this.rewind(_m97);
                    --this.inputState.guessing;
                }
                if (!synPredMatched97) break block16;
                ExpressionArithmetic o1 = this.multiplication_operand();
                switch (this.LA(1)) {
                    case 28: {
                        this.match(28);
                        ExpressionArithmetic o2 = this.addition_operand();
                        if (this.inputState.guessing == 0) {
                            result = new Multiplication(o1, o2);
                        }
                        break block17;
                    }
                    case 29: {
                        this.match(29);
                        ExpressionArithmetic o2 = this.addition_operand();
                        if (this.inputState.guessing == 0) {
                            result = new Division(o1, o2);
                        }
                        break block17;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            if (_tokenSet_2.member(this.LA(1)) && _tokenSet_10.member(this.LA(2))) {
                result = this.multiplication_operand();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final ExpressionArithmetic multiplication_operand() throws TokenStreamException, RecognitionException {
        ExpressionArithmetic result = null;
        switch (this.LA(1)) {
            case 5: {
                this.match(5);
                result = this.expression_arithmetic();
                this.match(7);
                break;
            }
            case 27: 
            case 32: {
                double d = this.number_double();
                if (this.inputState.guessing != 0) break;
                result = new NumberDouble(d);
                break;
            }
            default: {
                boolean synPredMatched101 = false;
                if ((this.LA(1) == 30 || this.LA(1) == 31) && _tokenSet_6.member(this.LA(2))) {
                    int _m101 = this.mark();
                    synPredMatched101 = true;
                    ++this.inputState.guessing;
                    try {
                        this.identifier();
                        this.match(5);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched101 = false;
                    }
                    this.rewind(_m101);
                    --this.inputState.guessing;
                }
                if (synPredMatched101) {
                    result = this.method_call();
                    break;
                }
                if ((this.LA(1) == 30 || this.LA(1) == 31) && _tokenSet_11.member(this.LA(2))) {
                    result = this.reference();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return result;
    }

    public final double number_double() throws TokenStreamException, RecognitionException {
        double result;
        block17: {
            Token s = null;
            Token d1 = null;
            Token d2 = null;
            result = 0.0;
            String text = "";
            switch (this.LA(1)) {
                case 27: {
                    s = this.LT(1);
                    this.match(27);
                    if (this.inputState.guessing != 0) break;
                    text = String.valueOf(String.valueOf(text)).concat("-");
                    break;
                }
                case 32: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            int _cnt119 = 0;
            while (true) {
                if (this.LA(1) == 32) {
                    d1 = this.LT(1);
                    this.match(32);
                    if (this.inputState.guessing == 0) {
                        text = String.valueOf(String.valueOf(text)).concat(String.valueOf(String.valueOf(d1.getText())));
                    }
                } else {
                    if (_cnt119 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                ++_cnt119;
            }
            block4 : switch (this.LA(1)) {
                case 34: {
                    this.match(34);
                    if (this.inputState.guessing == 0) {
                        text = String.valueOf(String.valueOf(text)).concat(".");
                    }
                    int _cnt122 = 0;
                    while (true) {
                        if (this.LA(1) == 32) {
                            d2 = this.LT(1);
                            this.match(32);
                            if (this.inputState.guessing == 0) {
                                text = String.valueOf(String.valueOf(text)).concat(String.valueOf(String.valueOf(d2.getText())));
                            }
                        } else {
                            if (_cnt122 >= 1) break block4;
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        ++_cnt122;
                    }
                }
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing != 0) break block17;
            result = Double.parseDouble(text);
        }
        return result;
    }

    public final ExpressionArithmetic function() throws TokenStreamException, RecognitionException {
        Function result;
        block6: {
            result = null;
            String id = null;
            LinkedList<ExpressionArithmetic> arguments = new LinkedList<ExpressionArithmetic>();
            id = this.identifier();
            this.match(5);
            switch (this.LA(1)) {
                case 5: 
                case 27: 
                case 30: 
                case 31: 
                case 32: {
                    ExpressionArithmetic argument = this.expression_arithmetic();
                    if (this.inputState.guessing == 0) {
                        arguments.add(argument);
                    }
                    while (this.LA(1) == 9) {
                        this.match(9);
                        argument = this.expression_arithmetic();
                        if (this.inputState.guessing != 0) continue;
                        arguments.add(argument);
                    }
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(7);
            if (this.inputState.guessing != 0) break block6;
            result = new Function(id, arguments.toArray(new ExpressionArithmetic[arguments.size()]));
        }
        return result;
    }

    public final long number_long() throws TokenStreamException, RecognitionException {
        Token d1 = null;
        long result = 0L;
        String text = "";
        int _cnt125 = 0;
        while (true) {
            if (this.LA(1) == 32) {
                d1 = this.LT(1);
                this.match(32);
                if (this.inputState.guessing == 0) {
                    text = String.valueOf(String.valueOf(text)).concat(String.valueOf(String.valueOf(d1.getText())));
                }
            } else {
                if (_cnt125 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt125;
        }
        if (this.inputState.guessing == 0) {
            result = Long.parseLong(text);
        }
        return result;
    }
}

