/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import lindenmayer.parser.SymbolConstant;
import lindenmayer.parser.SymbolDefinition;
import lindenmayer.parser.Variable;
import lindenmayer.parser.WrongSignatureException;

public class SymbolVariable {
    SymbolDefinition symbol;
    Variable[] parameters;

    public SymbolVariable(SymbolDefinition symbol, Variable[] parameters) throws WrongSignatureException {
        if (parameters == null && symbol.parameterCount > 0 || parameters.length != symbol.parameterCount) {
            throw new WrongSignatureException(String.valueOf(String.valueOf(new StringBuffer("Symbol ").append(symbol.id).append(" requires ").append(symbol.parameterCount).append(" parameters, found: ").append(parameters.length))));
        }
        this.symbol = symbol;
        this.parameters = parameters;
    }

    public void retrieveValues(SymbolConstant source) {
        if (source.symbol != this.symbol) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].value = source.parameters[i];
        }
    }

    public String toString() {
        String result = this.symbol.id;
        if (this.parameters.length > 0) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf("(".concat(String.valueOf(String.valueOf(this.parameters[0].toString()))))));
            for (int i = 1; i < this.parameters.length; ++i) {
                result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(", ".concat(String.valueOf(String.valueOf(this.parameters[i].toString()))))));
            }
            result = String.valueOf(String.valueOf(result)).concat(")");
        }
        return result;
    }
}

