/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.system;

import lindenmayer.system.SymbolInstance;

public class Word
implements Cloneable {
    static final int INITIAL_CAPACITY = 10;
    SymbolInstance[] symbols;
    int size;

    public Word() {
        this.size = 0;
        this.symbols = new SymbolInstance[10];
    }

    public Word(SymbolInstance symbol) {
        this.symbols = new SymbolInstance[1];
        this.size = 1;
        this.symbols[0] = symbol;
    }

    public Word(SymbolInstance[] symbols) {
        this.symbols = new SymbolInstance[symbols.length];
        System.arraycopy(symbols, 0, this.symbols, 0, symbols.length);
        this.size = symbols.length;
    }

    public Word(Word word) {
        this.symbols = new SymbolInstance[word.size];
        for (int i = 0; i < word.size; ++i) {
            this.symbols[i] = (SymbolInstance)word.symbols[i].clone();
        }
        this.size = word.size;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.symbols.length;
        if (oldCapacity < minCapacity) {
            SymbolInstance[] old = this.symbols;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.symbols = new SymbolInstance[newCapacity];
            System.arraycopy(old, 0, this.symbols, 0, this.size);
        }
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public SymbolInstance get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.symbols[index];
    }

    public SymbolInstance set(int index, SymbolInstance value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        SymbolInstance oldValue = this.symbols[index];
        this.symbols[index] = value;
        return oldValue;
    }

    public boolean add(Object object) {
        if (!(object instanceof SymbolInstance)) {
            throw new IllegalArgumentException();
        }
        this.ensureCapacity(this.size + 1);
        this.symbols[this.size++] = (SymbolInstance)object;
        return true;
    }

    public void append(SymbolInstance symbol) {
        this.ensureCapacity(this.size + 1);
        this.symbols[this.size++] = symbol;
    }

    public void appen(SymbolInstance[] symbols) {
        int newSize = this.size + symbols.length;
        this.ensureCapacity(newSize);
        System.arraycopy(symbols, 0, this.symbols, this.size, symbols.length);
        this.size = newSize;
    }

    public void append(Word word) {
        int newSize = this.size + word.size;
        this.ensureCapacity(newSize);
        for (int i = this.size; i < newSize; ++i) {
            this.symbols[i] = (SymbolInstance)word.get(i).clone();
        }
        this.size = newSize;
    }

    public Object clone() {
        return new Word(this);
    }

    static {
        INITIAL_CAPACITY = 10;
    }
}

