/*
 * Decompiled with CFR 0.152.
 */
package lindenmayer.parser;

import java.util.HashMap;
import java.util.Map;
import lindenmayer.parser.Method;
import lindenmayer.parser.Provider;
import lindenmayer.parser.SymbolInterpretation;
import lindenmayer.parser.UndefinedVariableException;
import lindenmayer.parser.UnknownMethodException;
import lindenmayer.parser.Variable;
import lindenmayer.parser.WordConstant;
import lindenmayer.parser.WrongSignatureException;

public class Interpretation {
    String id;
    SymbolInterpretation[] symbolInterpretations;
    Map symbolMap;
    String interpreter;

    public Interpretation(String id, SymbolInterpretation[] symbolInterpretations, String interpreter) {
        if (symbolInterpretations == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.symbolInterpretations = symbolInterpretations;
        this.interpreter = interpreter;
        this.symbolMap = new HashMap();
        for (int i = 0; i < symbolInterpretations.length; ++i) {
            this.symbolMap.put(symbolInterpretations[i].symbol.symbol, symbolInterpretations[i]);
        }
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public void setProvider(Provider[] provider) throws UndefinedVariableException, WrongSignatureException, UnknownMethodException {
        HashMap<String, Variable> variableIdMap = new HashMap<String, Variable>();
        HashMap<String, Method> methodIdMap = new HashMap<String, Method>();
        for (int p = 0; p < provider.length; ++p) {
            Method[] methods;
            Variable[] variables = provider[p].getVariables();
            if (variables != null) {
                for (int i = 0; i < variables.length; ++i) {
                    variableIdMap.put(variables[i].getId(), variables[i]);
                }
            }
            if ((methods = provider[p].getMethods()) == null) continue;
            for (int i = 0; i < methods.length; ++i) {
                methodIdMap.put(methods[i].getId(), methods[i]);
            }
        }
        for (int i = 0; i < this.symbolInterpretations.length; ++i) {
            this.symbolInterpretations[i].assignMethods(methodIdMap);
            this.symbolInterpretations[i].assignVariables(variableIdMap);
        }
    }

    public void execute(WordConstant word) {
        for (int i = 0; i < word.symbols.length; ++i) {
            SymbolInterpretation s = (SymbolInterpretation)this.symbolMap.get(word.symbols[i].symbol);
            if (s == null) continue;
            s.execute(word.symbols[i]);
        }
    }

    public String toString() {
        String result = "interpretation";
        if (this.id != null) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(this.id))))));
        }
        result = String.valueOf(String.valueOf(result)).concat(" =\n(\n");
        for (int i = 0; i < this.symbolInterpretations.length; ++i) {
            result = String.valueOf(String.valueOf(result)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.symbolInterpretations[i].toString())).concat("\n"))));
        }
        result = String.valueOf(String.valueOf(result)).concat(")");
        return result;
    }
}

