%%%  src/INet/Description/Check.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Consistency Checking of Net Descriptions}

\begin{code}
module INet.Description.Check where

import INet.Description

import qualified INet.Utils.Vector as V

import Data.List
\end{code}

\begin{code}
atPortTargetDescription :: NetDescription nLab
  -> PortTargetDescription
  -> PortTargetDescription
atPortTargetDescription nd (SourcePort i) = V.atErr "at SourcePort S" (source nd) (pred i)
atPortTargetDescription nd (TargetPort i) = V.atErr "at TargetPort S" (target nd) (pred i)
atPortTargetDescription nd (InternalPort n i) = V.atErr ("at InternalPort " ++ shows n " ") (portDescriptions (V.atErr "at InternalPort " (nodes nd) n)) i
\end{code}

\begin{code}
ptdPairs :: NetDescription nLab -> [(PortTargetDescription, PortTargetDescription)]
ptdPairs nd = let
    sourceAssocs = [(SourcePort $ succ i, ptd) | (i, ptd) <- V.assocs $ source nd]
    targetAssocs = [(TargetPort $ succ i, ptd) | (i, ptd) <- V.assocs $ target nd]
    internalAssocs = [(InternalPort n i, ptd) | (n, d) <- V.assocs (nodes nd), (i, ptd) <- V.assocs (portDescriptions d)]
  in sourceAssocs ++ targetAssocs ++ internalAssocs
\end{code}

|ptdRel| is used in |INet.Description.Dot|.
\begin{code}
ptdRel :: NetDescription nLab -> [(PortTargetDescription, PortTargetDescription)]
ptdRel nd = nub . sort $ map (\ (x,y) -> if x <= y then (x,y) else (y,x)) ps
  where ps = ptdPairs nd
\end{code}

\begin{code}
checkNetDescription :: NetDescription nLab
  -> [( PortTargetDescription, PortTargetDescription, PortTargetDescription)]
checkNetDescription nd = [(ptd1, ptd2, ptd3) | (ptd1, ptd2) <- ptdPairs nd
                         , let ptd3 = atPortTargetDescription nd ptd2
                         , ptd1 /= ptd3 ]
\end{code}

