%%%  src/INet/Description/InterfacePolarity.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Interface Polarity of Net Descriptions}

\begin{code}
module INet.Description.InterfacePolarity where

import INet.Description
import INet.Polarity (Polarity)
import INet.Utils.Vector  (Vector, (!))
import qualified INet.Utils.Vector as V
\end{code}

From just a |NetDescription|, polarities for its interface
can only be inferred if each source and target connection
is incident to an internal node.
We will use this for start nets, where this is not a significant restriction.

\begin{code}
interfacePolarity :: INetLang nLab -> NetDescription nLab -> Maybe (Vector Polarity, Vector Polarity)
interfacePolarity lang descr = let
    h (InternalPort n i) = Just $ let
        nd = nodes descr ! n
        lab = nLab nd
      in polarity lang lab ! i
    h _ = Nothing
  in do
    ps1 <- V.mapM h $ source descr
    ps2 <- V.mapM h $ target descr
    return (ps1, ps2)
\end{code}

