%%%  src/INet/Description/Show.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{|Show| Instances for Net Descriptions}

\begin{code}
module INet.Description.Show where

import INet.Description

import qualified INet.Utils.Vector as V
\end{code}

\begin{code}
instance Show nLab => Show (NodeDescription nLab) where
  show (NodeDescription nLab ptds) = unwords ["NodeDescr", show nLab, show (V.toList ptds)]
\end{code}


\begin{code}
instance Show nLab => Show (NetDescription nLab) where
  show (NetDescription src trg ns) = unlines $
    "NetDescription" : map ("  " ++)
      (["source = " ++ show (V.toList src)
       ,"target = " ++ show (V.toList trg)
       ,"ns = "
       ]
       ++ zipWith (\ i n -> ("  " ++ shows i ("  " ++ show n))) [0 ..] (V.toList ns)
      )
\end{code}

