%%%  src/INet/InetsFile/MkExamples.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{|INet.InetsFile.MkExamples| --- Create Examples}

\begin{ModuleHead}
\begin{code}
module INet.InetsFile.MkExamples where

-- |import INet.PTerm|

import System.Random
import System.IO
\end{code}
\end{ModuleHead}

Generating alternative start lists for |sort.inet|:
\begin{code}
randomIntList :: Int -> Int -> IO [Int]
randomIntList max len = mapM (const $ randomRIO (0,max)) [1..len]

randomSortStart :: Int -> Int -> IO ()
randomSortStart max len =
   randomIntList max len >>= putStrLn . listExpr "Nil"

listExpr :: String -> [Int] -> String
listExpr arg ks = foldr (\ i t -> "Num(" ++ show i ++ ", " ++ t ++ ")") arg ks

chunk :: Int -> [a] -> [[a]]
chunk k [] = []
chunk k xs = case splitAt k xs of
               (ys, zs) -> ys : chunk k zs

randomSortChunked :: Int -> Int -> IO ()
randomSortChunked max len = do
    h <- openFile outFile WriteMode
    readFile (dir ++ "sortC.inet-pre") >>= hPutStrLn h
    list <- randomIntList max len
    hPutStr h "    "
    hPutStr h
      $ foldr1 (\ xs ys -> xs ++ ",\n    " ++ ys)
      $ reverse
      $ zipWith3 mkEq ("BSort(r)" : chunkVars) (chunkVars ++ ["Nil"]) (chunk chunkSize list)
    hPutStrLn h ";"
    readFile (dir ++ "sortC.inet-post") >>= hPutStrLn h
    hClose h
  where
    dir = "../data/Inets/"
    outFile = dir ++ "sortC" ++ shows len ".inet"

    mkEq result arg is = result ++ "~" ++ listExpr arg is
    chunkSize = 10
    lastChunk = pred (len `div` chunkSize)
    chunkVars = map (("chunk" ++) . show) [1..lastChunk]
\end{code}
