%%%  src/INet/Polar/Create.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Creation from Descriptions}\sectlabel{INet.Polar.Create}

\begin{ModuleHead}
\begin{code}
{-# LANGUAGE ScopedTypeVariables, RecursiveDo #-}
module INet.Polar.Create where

import INet.Polar.INet
import INet.Polar.Reduce
import INet.Description
import INet.Description.InterfacePolarity (interfacePolarity)

import qualified INet.Utils.Vector as V

import Control.Concurrent
\end{code}
\end{ModuleHead}

\begin{code}
createNet :: (Show nLab, Eq nLab -- for |debugging|
  ) => INetLang nLab
    -> NetDescription nLab -> IO (Ports nLab, Ports nLab)
createNet lang descr = let
    mkConns = V.mapM (\ pl -> fmap (Port pl) newEmptyMVar)
  in case interfacePolarity lang descr of
    Nothing -> fail "createNet: insufficient polarity information"
    Just (srcPol, trgPol) -> do
      src <- mkConns srcPol
      trg <- mkConns trgPol
      replaceNet lang descr src trg
      return (src, trg)
\end{code}


\begin{code}
\end{code}

