%%%  src/INet/Simple.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Simple Nets}

\begin{code}
module INet.Simple where

import INet.Description
import INet.Rule

import Text.JSON
import INet.Description.JSON
\end{code}

\begin{code}
newtype NLab = NLab {unNLab :: String} deriving (Eq, Ord)

instance Show NLab where show (NLab s) = s
instance JSON NLab where
  readJSON = fmap NLab . readJSON
  showJSON (NLab s) = showJSON s
\end{code}

\begin{code}
readRules :: FilePath -> IO [Rule NLab]
readRules fp = do
  s <- readFile fp
  case readJSONs =<< decodeStrict s of
    Ok rs -> return rs
    Error e -> fail e
\end{code}

\begin{code}
readNet :: FilePath -> IO (NetDescription NLab)
readNet fp = do
  s <- readFile fp
  case readNetDescription =<< decodeStrict s of
    Ok nd -> return nd
    Error e -> fail e
\end{code}

\begin{code}
showNet :: NetDescription NLab -> String
showNet = encodeStrict

printNet :: NetDescription NLab -> IO ()
printNet = putStrLn . showNet

writeNet :: FilePath -> NetDescription NLab -> IO ()
writeNet fp = writeFile fp . showNet
\end{code}

\begin{code}
showRules :: [Rule NLab] -> String
showRules = encodeStrict

printRules :: [Rule NLab] -> IO ()
printRules = putStrLn . showRules

writeRules :: FilePath -> [Rule NLab] -> IO ()
writeRules fp = writeFile fp . showRules
\end{code}
