%%%  src/INet/Utils/GhostView.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Calling GhostView}

\begin{code}
{-# LANGUAGE CPP #-}
module INet.Utils.GhostView where

import INet.Utils.TmpFile
import System.Process (system)
\end{code}

\begin{code}
ghostViewString :: String -> IO ()
ghostViewString s = do
  tmpFile <- writeTmp ".eps" s
  ghostViewFile tmpFile
\end{code}

\begin{code}
ghostViewFile :: FilePath -> IO ()
ghostViewFile file = do

#ifdef mingw32_HOST_OS

-- This is for MS Windows:
--
-- If you do not have |gsview32| in you PATH, then
-- comment the first ``|system|'' line,
-- uncomment the second ``|system|'' line,
-- and edit the hard-coded path to fit your installation.

  system $ unwords ["gsview32", file]
  -- |system $ unwords ["\"J:\\Program Files\\Ghostgum\\gsview\\gsview32.exe\"", file]|

#elif darwin_HOST_OS

-- This is for MacOS X:

  let eps = file ++ ".eps"
--  |system $ unwords ["mv", file, eps, ";", "open -a /Applications/Preview.app", eps, "&"]|
  system $ unwords ["mv", file, eps, ";", "open", eps, "&"]

#else

-- This is the default, and should work on most UNIX-like systems
-- (including Linux) with  gv installed.
-- http://www.gnu.org/software/gv/

  system $ unwords ["gv", file, "&"]

#endif

  return ()
\end{code}

%{{{ EMACS lv
% Local Variables:
% folded-file: t
% fold-internal-margins: 0
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% end:
%}}}
