%%%  src/INet/Utils/Map.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Map Utilities}

\begin{code}
{-# LANGUAGE ScopedTypeVariables #-}
module INet.Utils.Map where

import Data.Map (Map)
import qualified Data.Map as Map
import Data.List (foldl')
\end{code}

The result of |mkLookup2 triples|
will raise run-time errors for arguments outside the domain defined by |triples|.

\begin{code}
mkLookup2 :: forall a b c . (Show a, Show b, Ord a, Ord b) => [((a,b),c)] -> a -> b -> c
mkLookup2 triples = let
    f m0 ((a,b),c) = Map.insertWith Map.union a (Map.singleton b c) m0
    m :: Map a (Map b c)
    m = foldl' f Map.empty triples
  in \ x y -> (m Map.! x) Map.! y
\end{code}
