%%%  src/INet/Description/Flip.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Calculating Mirror Images of Net Descriptions}

\begin{code}
module INet.Description.Flip where

import INet.Description
\end{code}

\begin{code}
flipPortTargetDescription :: PortTargetDescription -> PortTargetDescription
flipPortTargetDescription (SourcePort pi1) = TargetPort pi1
flipPortTargetDescription (TargetPort pi2) = SourcePort pi2
flipPortTargetDescription (InternalPort ni pi3) = InternalPort ni pi3
\end{code}

\begin{code}
flipNodeDescription :: NodeDescription nLab -> NodeDescription nLab
flipNodeDescription nd = NodeDescription
  { nLab = nLab nd
  , portDescriptions = fmap flipPortTargetDescription $ portDescriptions nd
  }
\end{code}

\begin{code}
flipNetDescription :: NetDescription nLab -> NetDescription nLab
flipNetDescription nd = NetDescription
  { source  = fmap flipPortTargetDescription  $ target nd
  , target  = fmap flipPortTargetDescription  $ source nd
  , nodes   = fmap flipNodeDescription        $ nodes nd
  }
\end{code}
