%%%  src/INet/Polarity.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Polarity}

\begin{ModuleHead}
\begin{code}
module INet.Polarity where
\end{code}
\end{ModuleHead}

Lafont \cite{Lafont-1990} and Banach and Papadopoulos \cite{Banach-Papadopoulos-1997}
use typed connections in their interaction nets,
where the two ports incident in a connection have the same type,
but different polarity.
Since we design our interaction net implementation as a run-time system,
types are currently not important,
% at that level,
and will be assumed to have been taken care of before net generation.
Polarity, however, drives several run-time decisions;
for the sake of readability, we define a special-purpose data-type for it
(and let Haskell's ``|deriving|'' mechanism provide us
with the default implementation of equality and ordering tests,
and of conversion to strings):

%\kern-2ex
\begin{code}
data Polarity = Neg | Pos
  deriving (Eq, Ord, Show)

opposite :: Polarity -> Polarity
opposite Neg = Pos
opposite Pos = Neg
\end{code}

\noindent
We will follow Lafont's convention of letting ``constructors''
have positive polarity, and ``functions'' negative polarity.

% Local Variables:
% folded-file: t
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% fold-internal-margins: 0
% end:
