%%%  src/INet/Simple/PolarTest.lhs
%%%
%%%  Copyright ©  2015 Wolfram Kahl
%%%
%%%  This file is part of HINet.
%%%
%%%  HINet is free software: you can redistribute it and/or modify
%%%  it under the terms of the GNU General Public License as published by
%%%  the Free Software Foundation, in version 3 of the License.
%%%
%%%  HINet is distributed in the hope that it will be useful,
%%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%%  GNU General Public License version 3 for more details.
%%%
%%%  You should have received a copy of the GNU General Public License
%%%  along with HINet.  If not, see <http://www.gnu.org/licenses/>.
\section{Top-level Testing Programs for Simple Nets using the Polar Implementation}

\begin{code}
module INet.Simple.PolarTest where

import INet.Rule
import INet.PTerm

import INet.Polar.INet
import INet.Polar.Create
import INet.Polar.Read

import INet.Simple
import INet.Simple.Rules

import INet.Utils.Usage

import INet.Utils.Vector  ((!))

import System.Environment
import System.IO (hPutStrLn, stderr)
\end{code}

\begin{code}
checkRules = mapM_ (checkRule arity) rules
\end{code}

\begin{code}
mainCheckRules = do
  checkRules
  putStrLn "=== checkRules DONE ==="

mainAck = do
  args <- getArgs
  case map read args of
    [m,n] -> do
      (src, _) <- createNet simpleLang $ ackND m n
      i <- getNat $ src ! 0
      putStrLn $ unwords ["getNat result: ackND", show m, show n, "=", show i]
    _ -> hPutStrLn stderr $ usage "ackND" "<nat> <nat>"

mainAck' =  do
  [m,n] <- fmap (map read) getArgs
  print $ unwords ["Haskell result: ack", show m, show n, "=", show $ ack m n]

mainFib = do
  args <- getArgs
  case map read args of
    [m] -> do
      (src, _) <- createNet simpleLang $ fibND m
      i <- getNat $ src ! 0
      putStrLn $ unwords ["getNat result: fibND", show m, "=", show i]
    _ -> hPutStrLn stderr $ usage "fibND" "<nat>"
\end{code}

%{{{ getNat :: Port NLab -> IO Integer
\begin{code}
getNat :: Port NLab -> IO Integer
getNat p  = getPTerm p >>= either fail return
          . natFromPTerm show (("Z" ==) . unNLab) (("S" ==) . unNLab)
\end{code}
%}}}

%{{{ EMACS lv
% Local Variables:
% folded-file: t
% fold-internal-margins: 0
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% end:
%}}}
