\section{FileUtils}

\begin{code}
module FileUtils where

import Module   ( mkModuleName, moduleNameSlashes )
import Outputable

import System.IO (hPutStrLn, stderr, withFile, IOMode(WriteMode))
import System.Directory (createDirectoryIfMissing)
import System.FilePath (pathSeparator)
\end{code}


\begin{code}
moduleFilePath :: String -> String -> String
moduleFilePath suffix newModName = moduleNameSlashes (mkModuleName newModName) ++ suffix

writeModuleSDoc :: String -> String -> String -> SDoc -> IO FilePath
writeModuleSDoc caller suffix newModName sdoc = let
      newModFilePath = moduleFilePath suffix newModName
      -- |pprStyle = mkUserStyle neverQualify (PartWay 80)|
  in do
    mkDirs newModFilePath
    withFile newModFilePath WriteMode $ \ h -> printForUser h neverQualify sdoc
    hPutStrLn stderr $ showSDoc $ text (caller ++ ":") <+>
      (text ("wrote module " ++ newModName) $+$
       text ("to           " ++ newModFilePath))
    return newModFilePath
\end{code}

\begin{code}
mkDirs :: FilePath -> IO ()
mkDirs s = let
    (_rfile, prefix) = break (pathSeparator ==) $ reverse s
  in case prefix of
    [] -> return ()
    _ : rdir -> createDirectoryIfMissing True $ reverse rdir
\end{code}


%{{{ EMACS lv
% Local Variables:
% folded-file: t
% fold-internal-margins: 0
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% end:
%}}}
