\section{HsExports}

List the exports of a Haskell module,
no matter whether compilable source, or compiled, including library.

\begin{code}
-- |module HsExports where|

import GetModuleExports (getTypedExportNames)
import PprUtils (pprint)

import GHC.Paths

-- package GHC
import GHC ( printExceptionAndWarnings
           , handleSourceError
           , runGhc
           , TyThing(..)
           , Id, idType
           , DataCon, dataConType
           )
import Class (Class(..), classTvsFds, classMethods)
import Name (pprPrefixName)
import TyCon (TyCon, tyConKind, tyConDataCons)
import HscTypes ()
import Module   ( ModuleName, mkModuleName, moduleNameString )
import Outputable
import MonadUtils (MonadIO(liftIO))

import System (getArgs)
import System.IO

import Prelude hiding (mod)
\end{code}

\begin{code}
main :: IO ()
main = do
  args <- getArgs
  case args of
    s : _ -> do
      listExports (mkModuleName s)
    _ -> hPutStrLn stderr "usage: HsExports <Module Name>"
\end{code}

\begin{code}
listExports :: ModuleName -> IO ()
listExports implModName = runGhc (Just GHC.Paths.libdir) $
  handleSourceError printExceptionAndWarnings $ do
    (_mod, ((names, insts), (ie1, ie2))) <- getTypedExportNames implModName
    liftIO $ do
      putStrLn $ moduleNameString implModName ++ " exports:"
      mapM_ (pprint . pprName) names
      putStrLn "=========== Globals ==============="
      mapM_ (pprint . pprInstInfo) insts
      putStrLn "=========== Package InstEnv ==============="
      mapM_ (pprint . pprInstEnvInfo) ie1
      putStrLn "=========== Home InstEnv ==============="
      mapM_ (pprint . pprInstEnvInfo) ie2
  where
    pprName (n, mty) = case mty of
        Nothing -> pprPrefixName n
        Just ty -> pprTyThing ty
    pprInstInfo (ii, d) = ppr ii $+$ nest 15 (pprId d)
    pprInstEnvInfo (i, d) = ppr i $+$ nest 15 (pprId d)
\end{code}

\begin{code}
pprTyThing :: TyThing -> SDoc
pprTyThing (AnId ident)   = text "Identifier:" <+> pprId ident
pprTyThing (ADataCon dc)  = text "DataCon:   " <+> pprDataCon dc
pprTyThing (ATyCon tc)    = text "TyCon:     " <+> pprTyCon tc
pprTyThing (AClass c)     = text "Class:     " <+> vcat
  (map ppr (classSCTheta c) ++
   (ppr c <+> ppr (classTvsFds c)) :
   (pprTyCon cTyCon) :
   map pprDataCon (tyConDataCons cTyCon) ++
   text "Members:" :
   nest 4 (vcat . map pprId $ classMethods c) :
   []
  )
  where
    cTyCon = classTyCon c
   
\end{code}

\begin{code}
pprId :: Id -> SDoc
pprId ident = ppr ident <+> text "::" <+> ppr (idType ident)
\end{code}

\begin{code}
pprDataCon :: DataCon -> SDoc
pprDataCon dc = ppr dc <+> text "::" <+> ppr (dataConType dc)
\end{code}

\begin{code}
pprTyCon :: TyCon -> SDoc
pprTyCon tc = ppr tc <+> text "::" <+> ppr (tyConKind tc)
\end{code}

\begin{code}

\end{code}

\begin{code}

\end{code}


%{{{ EMACS lv
% Local Variables:
% folded-file: t
% fold-internal-margins: 0
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% end:
%}}}
