\section{IfChanged}

\begin{code}
module IfChanged where

import Data.Map (Map)
import qualified Data.Map as Map
\end{code}


\begin{code}
forceIfCh :: (a -> Maybe a) -> a -> a
forceIfCh f x = case f x of Nothing -> x; Just x' -> x'
\end{code}

\begin{code}
ifChMap :: Ord a => (b -> Maybe b) -> Map a b -> Maybe (Map a b)
ifChMap f = fmap Map.fromList . ifChList (ifChSecond f) . Map.toList
\end{code}

\begin{code}
ifChFirst :: (a -> Maybe a) -> (a, b) -> Maybe (a, b)
ifChFirst f (x,y) = fmap (flip (,) y) $ f x
\end{code}

\begin{code}
ifChSecond :: (b -> Maybe b) -> (a, b) -> Maybe (a, b)
ifChSecond f (x,y) = fmap ((,) x) $ f y
\end{code}

\begin{code}
ifChBin :: (a -> b -> c) -> (a -> Maybe a) -> (b -> Maybe b) -> a -> b -> Maybe c
ifChBin p f g x y = case f x of
  Nothing -> fmap (p x) $ g y
  Just x' -> Just . p x' $ forceIfCh g y
\end{code}

\begin{code}
ifChPair :: (a -> Maybe a) -> (b -> Maybe b) -> (a, b) -> Maybe (a, b)
ifChPair f g (x,y) = ifChBin (,) f g x y
\end{code}

\begin{code}
ifChList :: (a -> Maybe a) -> [a] -> Maybe [a]
ifChList _ [] = Nothing
ifChList f (x : xs) = ifChBin (:) f (ifChList f) x xs
\end{code}



%{{{ EMACS lv
% Local Variables:
% folded-file: t
% fold-internal-margins: 0
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% end:
%}}}
