\section{Instantiate}

Automatic instances:
  If sufficient class members are exported
  (and QuickCheck tests of the class are passed),
  generate an instance.

|Instantiate ClassesModule ImplementationModule {InstancesModule}|

\edcomm{WK}{Still missing: Propagation of constraints from superclass instances to subclass instances.}


%{{{ imports
\begin{code}
-- |module Instantiate where|

-- |import Language.Haskell.Exts.Syntax|

import GetModuleExports (moduleExports, Exports(..))
import MatchTypes  ( Subst, unify, unifySubsts
                   , matchType
                   , substType, substTyVar, substTheta
                   , elemTheta, myPredTyVars, myThetaTyVars
                   )
import PprUtils  ( pprId, pprTyped, stringOfId, blockComment
                 , pprTyConImport' )
import FileUtils (moduleFilePath, writeModuleSDoc)


-- package GHC
import GHC ( Id, idType, Class(..) )
import Type (Type, mkTyVarTy, PredType(ClassP), mkPredTy, ThetaType)
import TcType  ( tcEqTypes, tcEqPred, mkSigmaTy
               , tcSplitSigmaTy, tcSplitTyConApp_maybe
               , pprTheta, pprThetaArrow, {- pprPred, -} pprParendType)
import Var (TyVar)
import VarSet (VarSet, elemVarSet, varSetElems)
import Class (classArity, classExtraBigSig, DefMeth(NoDefMeth))
import Module   ( ModuleName, mkModuleName, moduleNameString )
import Outputable


import System (getArgs)
import System.IO (hPutStrLn, stderr)

import Prelude hiding (mod)
import Data.Maybe (mapMaybe)
import Data.List (nub, nubBy, partition)

-- import Data.Set (Set)
import qualified Data.Set as Set
import Data.Map (Map)
import qualified Data.Map as Map

import Control.Arrow (first)
import Control.Monad.State (get, put, StateT, runStateT)
import Control.Monad.Trans (lift)
-- import Control.Monad (MonadPlus(mzero))
\end{code}
%}}}

%{{{ main
\begin{code}
main :: IO ()
main = do
  args0 <- getArgs
  let (extraLangExts, args) = getLangExts args0        
  case args of
    classesModule : implModule : args' -> let
        classesModName = mkModuleName classesModule
        implModName = mkModuleName implModule
        newModName = case args' of
          [] -> moduleNameString implModName ++ '.' : moduleNameString classesModName
          nm : _ -> nm
      in instantiateImpl classesModName implModName newModName extraLangExts
    _ -> hPutStrLn stderr "usage: Instantiate ClassesModule ImplementationModule {TargetModule}"

getLangExts :: [String] -> ([String], [String])
getLangExts ("-e" : e : ss) = first (e :) $ getLangExts ss
getLangExts ss              = ([], ss)
\end{code}
%}}}

%{{{ instantiateImpl
\begin{code}
instantiateImpl :: ModuleName -> ModuleName -> String -> [String] -> IO ()
instantiateImpl classesModName implModName newModName extraLangExts = do
  [classExports, implExports] <- moduleExports [classesModName, implModName]
  let classes  = Set.toList $ exportClasses classExports
  let implMap  = Set.fold (\ ident -> Map.insert (stringOfId ident) ident) Map.empty
               $ exportIds implExports
  let outClasses = mapMaybe (doClass implMap) classes
      pprOutClass (Nothing, sdoc) = blockComment sdoc
      pprOutClass (Just _, sdoc) = sdoc
  let outHeads = mapMaybe fst outClasses
      -- |outPreds = outHeads >>= (\ (th,p) -> p : th)|
      -- |outTyCons = thetaTyCons outPreds|

      outSingleParams = nub $ mapMaybe (f . snd) outHeads
        where
          f (ClassP _ [ty]) = fmap fst $ tcSplitTyConApp_maybe ty
          f _ = Nothing
  let langExts = if 1 < maximum (0 : map classArity classes)
                 then "MultiParamTypeClasses" : "FlexibleInstances" : extraLangExts
                 else extraLangExts
      langPragma = case langExts of
         [] -> id
         _ -> (++) (zipWith (\ s e -> text $ s ++ e)
                            ("{-# LANGUAGE " : repeat (replicate 12 ' ' ++ ","))
                            langExts)
              . (:) (text "  #-}")
  let newModFilePath = moduleFilePath ".hs" newModName
  insert <- let
      insertFileName = newModFilePath ++ "_insert"
      comm = ("-- Instantiate insertion from " ++) . (insertFileName ++) . (' ' :)
      in do
        s <- readFile insertFileName
        hPutStrLn stderr $ "Instantiate: found insert: " ++ insertFileName
        return
          $ (:) (text $ '\n' : comm "BEGIN")
          . (:) (text s)
          . (:) (text $ comm "END\n")
       `catch` \ _ioe -> return id
         
    
  writeModuleSDoc "Instantiate" ".hs" newModName . vcat
    $  langPragma
    $  (:) (text "module" <+> text newModName <+> text "where")
    $  (:) (text "")
    $  (:) (text "import" <+> ppr classesModName)
    $  (:) (text "import qualified " <+> ppr implModName)
    $  (++) (map pprTyConImport' outSingleParams)
    $  insert
    $  (:) (text "")
    $  map (($+$ text "") . pprOutClass) outClasses
  return ()
\end{code}
%}}}

%{{{ doClass
\begin{code}
doClass :: Map String Id -> Class -> Maybe (Maybe (ThetaType, PredType), SDoc)
doClass implMap c = let
  -- |theta = classSCTheta c|
  -- |(tvs, _fds) = classTvsFds c|
  (tyvars, _fundeps, _sc_theta, _sc_sels, _ats, op_stuff) = classExtraBigSig c
  cHead0 = ClassP c $ map mkTyVarTy tyvars

  cSubstId :: Subst
  cSubstId = foldr (\ v -> Map.insert v (mkTyVarTy v)) Map.empty tyvars 
  
  findMember :: (Id, DefMeth) -> StateT (Map TyVar Type) Maybe
       (Either SDoc (Subst -> VarSet -> (([PredType], Bool), SDoc)))
  findMember (memberId, defaultImpl) = let
      memberName = stringOfId memberId
      (memForalls, memTheta, memTy) = tcSplitSigmaTy $ idType memberId
      memTheta1 = filter (not . tcEqPred cHead0) memTheta
      memForalls1 = filter (`notElem` tyvars) memForalls
      memInternalTy = mkSigmaTy memForalls1 memTheta1 memTy
      pprMember = pprTyped memberId memInternalTy
    in case Map.lookup memberName implMap of
         Nothing -> let report msg = return . Left $ text ("{- " ++ msg ++ " for:")
                                     <+> pprMember <+> text "-}"
           in case defaultImpl of
             NoDefMeth -> report "NO DEFAULT IMPLEMENTATION" -- |mzero|    -- failure
             _ -> report "default implementation"
         Just implId  -> let
             (_iForalls, iTheta, iTy) = tcSplitSigmaTy $ idType implId
           in do
             let (_memInnerForalls, memInnerTheta, memTy') = tcSplitSigmaTy memTy
             case unify memTy' iTy of
               Nothing -> return . Left $ text "{- type mismatch:"
                                        <+> (pprTyped memberId memTy' $+$ pprTyped implId iTy) <+> text "-}"
               Just ((memSubst, _iSubst), _ty) -> do
                 cSubst0 <- get
                 (_, cSubst1) <- lift $ unifySubsts cSubst0 memSubst
                 put cSubst1
                 return . Right $ \ cSubst thetaTyVars -> let
                     (_memInstForalls, _memInstTheta, memTy'')
                       = tcSplitSigmaTy $ substType cSubst memTy
                   in case matchType iTy memTy'' of
                     Nothing -> (,) ([], False) $ text "{- type mismatch2:"
                        <+> (pprTyped memberId memTy'' $+$ pprTyped implId iTy) <+> text "-}"
                     Just instSubst -> let
                         memTheta2 = substTheta cSubst (memTheta1 ++ memInnerTheta)
                         iTheta1 = filter (not . (`elemTheta` memTheta2)) $ substTheta instSubst iTheta
                         iTheta1V = map (\ pr -> (pr, varSetElems $ myPredTyVars pr)) iTheta1
                         (up, local) = partition (all (`elemVarSet` thetaTyVars) . snd) iTheta1V
                         nok (_pr, vars) = not $ any (`elemVarSet` thetaTyVars) vars
                         noks = filter nok local
                       in if null noks
                         then  (,) (map fst up, True)
                               (pprHsVar memberId <+> text "=" <+> withPprStyle defaultUserStyle (pprHsVar implId))
                         else  (,) ([], False) . blockComment
                         $    (text "   class member:   " <+> pprId memberId)
                         $+$  (text "   implementation: " <+> pprId implId)
                         $+$  (text "   unsatisfiable constraints:" <+> pprTheta (map fst noks))
 in case runStateT (mapM findMember op_stuff) cSubstId of
   Nothing -> Nothing
   Just (results, cSubst) -> Just $ let
         cPred = ClassP c $ map (substTyVar cSubst) tyvars
         -- \edcomm{WK}{unqualified |TyCon|s are not yet automatically imported!}
         pprCPred = {- |withPprStyle defaultUserStyle $| -} pprParendType (mkPredTy cPred)
         thetaTyVars = myThetaTyVars $ cPred : [] -- |substTheta cSubst sc_theta|
         h has prs theta [] = (has, (reverse prs, nubBy tcEqPred theta))
         h has prs theta (Left pr : rs) = h has (pr : prs) theta rs
         h has prs theta (Right f : rs) = let ((th, b), pr) = f cSubst thetaTyVars
                                   in h (has || b) (pr : prs) (th ++ theta) rs
     in let -- separating binding groups to avoid shadowing warning
         (hasMemberImpl, (prs, theta)) = h False [] [] results
     in (,) 
        (if tcEqPred cPred cHead0 || not hasMemberImpl then Nothing
         else Just (theta, cPred)
        )
        (
         (text "instance" <+> pprThetaArrow theta <+> pprCPred <+> text "where")
         -- |$+$ text "-- thetaTyVars =" <+> ppr (varSetElems thetaTyVars)|
         $+$ nest 2 (vcat prs)
        )

_predTypeIsClassPred :: Class -> [TyVar] -> PredType -> Bool
_predTypeIsClassPred c tyvars (ClassP c' tys) = c == c' && tcEqTypes (map mkTyVarTy tyvars) tys
_predTypeIsClassPred _ _ _ = False
\end{code}
%}}}

%{{{ EMACS lv
% Local Variables:
% folded-file: t
% fold-internal-margins: 0
% eval: (fold-set-marks "%{{{ " "%}}}")
% eval: (fold-whole-buffer)
% end:
%}}}
