/** 
 * Set Bag Conversion Module
 * This module provide the functions to convert a set to bag or a bag to set.
*/
#include <bdd.h>
#include <iostream>
#include <bitset>
#include "bag.h"
#include "set.h"

using namespace std;

/** 
 * This function converts a bag, bag, to a set and returns it. The function removes the cardinality part of elements. 
 * The elements with cardinality greater that zero will be present in the result set. Otherwise, they won't. 
 */
bdd bag2set(bdd bag){

	bdd u;	
	bdd temp1;
	int member;
	for (int i =1; i<=levels;i++)
    {
   	
    if (bagIsMember(bdd_ithvar(i),bag))
     {
				    temp1 = bdd_ithvar(i);
     }
    else 			  
     {     
        temp1 = bdd_nithvar(i);    
     }
				for (int k=1 ; k<=levels; k++)
						{
          if (k != i)
										   temp1 = temp1 & bdd_nithvar(k);
          else
             temp1 = temp1 & bdd_ithvar(k);
						}
   	
	   u = u | temp1;
	}	
	
	return u;
}

/**
 * This function converts a given set to a bag. The result will be having a an extension for cardinality part. 
*  The elements that are present will have a cardinality of 1, otherwise it will be 0.
 */ 
bdd set2bag(bdd set){


	bdd u;	
	bdd temp1;
	u = set;
	temp1 = set;
	int member;
	for (int i =1; i<=levels;i++)
    {
    	if (existsInSet(bdd_ithvar(i), set))
        {   //cout << "i= " << i << " exists " << endl; 
            temp1 = setOcc(i,1,set);
       	}
        else 
        {   //cout << "i= " << i << " does not exists " << endl; 
        	   temp1 = setOcc(i,0,set);
        }
								u = u & temp1;
    }
    
	//bdd_printdot(u);
	return u;
}
