/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ui_FlatProjectEditor.h"
#include "ProjSummaryUiPart.h"
#include "DesProjectNotifications.h"

namespace DESpot
{
	class DesFlatProject;
	class FlatProjSummaryUiPart: public ProjSummaryUiPart
	{
		public:
			FlatProjSummaryUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesFlatProject* pProject);
			virtual ~FlatProjSummaryUiPart(void);

		private:
			DesFlatProject* project();
			
			void initWidgets(Ui::FlatProjectEditorUI* pUiContainer);
			
			void updateUi();
			void updateNonBlockUi();
			void updateCtrlUi();
		
		//Project notifications
		private:
			virtual void onCtrlStatusChanged();
			virtual void onNonBlockStatusChanged();
		
		//Widgets
		private:
			QLabel* m_nonBlockNotChkLabel;
			OutputButtonGroup* m_nonbBlockRadioBtnGroup;
			QRadioButton* m_smryNonBlockYesWidg;
			QRadioButton* m_smryNonBlockNoWidg;
			
			QLabel* m_smryNonBlockVerifiedLabel;
			QDateTimeEdit* m_smryNonBlockDateStampWidg;
		
			QLabel* m_ctrlNotChkLabel;
			OutputButtonGroup* m_ctrlRadioBtnGroup;
			QRadioButton* m_smryCtrlYesWidg;
			QRadioButton* m_smryCtrlNoWidg;

			QLabel* m_smryCtrlVerifiedLabel;
			QDateTimeEdit* m_smryCtrlDateStampWidg;

			QLabel* m_nonblockSpacer1;
			QLabel* m_nonblockSpacer2;
			QLabel* m_nonblockSpacer3;
			QLabel* m_nonblockSpacer4;

			QLabel* m_ctrlSpacer1;
			QLabel* m_ctrlSpacer2;
			QLabel* m_ctrlSpacer3;
			QLabel* m_ctrlSpacer4;

	};

} //end of namespace DESpot
