/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include <QString>

class QTextStream;

namespace DESpot
{
	class Des;
	class DesState;
	class DesEvent;
	class DesTransition;

	class DesPrinter
	{
		public:
			DesPrinter(const Des& des);
			~DesPrinter(void);

		public:
			void print(const std::wstring& fileName);
			void print(QTextStream& out);

		private:
			void printDes(QTextStream& out);
			void printDesHeader(QTextStream& out);
			
			void printDesStates(QTextStream& out);
			void printState(QTextStream& out, const DesState& state);

			void printDesEvents(QTextStream& out);
			void printEvent(QTextStream& out, const DesEvent& event);

			void printDesTransitions(QTextStream& out);
			void printTransition(QTextStream& out, const DesTransition& trans);


		private:
			QString toString(const std::wstring& stdString);
			QString toString(unsigned long long value);

			QString getDesType();
			QString getDesIntegrity();
			QString getStateMarkStatus(const DesState& state);
			QString getStateReachStatus(const DesState& state);
			QString getEventCtrlStatus(const DesEvent& event);
			QString getEventType(const DesEvent& event);



		private:
			const Des& m_des;

		private:
			static const QString cFileHeader;
			static const QString cStateHeader;
			static const QString cEventHeader;
			static const QString cTransitionHeader;

			static const QString cDesNameLabel;

			static const QString cDesTypeLabel;
			static const QString cDesTypeVal_Regular;
			static const QString cDesTypeVal_Subsystem;
			static const QString cDesTypeVal_Interface;

			static const QString cDesFileNameLabel;
			static const QString cDesFileVersionLabel;
			static const QString cDesFileVersion;

			static const QString cDesIntegLabel; 
			static const QString cDesIntegDateLabel;
			static const QString cDesIntegDatePrefix;
			static const QString cDesIntegStatusVal_Yes;
			static const QString cDesIntegStatusVal_No; 
			static const QString cDesIntegStatusVal_NotVerified;

			static const QString cDesStateMarkedVal_Yes;
			static const QString cDesStateMarkedVal_No;
			static const QString cDesStateReachableVal_Unknown;
			static const QString cDesStateReachableVal_Yes;
			static const QString cDesStateReachableVal_No;
			static const QString cDesEventCtrlVal_Yes;
			static const QString cDesEventCtrlVal_No;
			static const QString cDesEventTypeVal_Def;
			static const QString cDesEventTypeVal_Req;
			static const QString cDesEventTypeVal_Ans;
			static const QString cDesEventTypeVal_Ld;

			static const QString cStateNameLabel;
			static const QString cInitStateLabel;
			static const QString cNoInitialState;
			static const QString cStateCountLabel; 
			static const QString cMarkedCountLabel;
			static const QString cStateAliasLabel; 
			static const QString cStateMarkedLabel;

			static const QString cEventCountLabel;
			static const QString cEventCtrlCountLabel;
			static const QString cEventUnctrlCountLabel;
			static const QString cEventDefCountLabel;
			static const QString cEventReqCountLabel;
			static const QString cEventAnsCountLabel;
			static const QString cEventLdataCountLabel; 

			static const QString cEventNameLabel; 
			static const QString cEventAliasLabel;
			static const QString cEventCtrlLabel; 
			static const QString cEventTypeLabel;

			static const QString cTransCountLabel;
			static const QString cSelfTransCountLabel;
			static const QString cSelfTransLabel;
	};

} //end of namespace DESpot
