/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "OutputButtonGroup.h"
#include <QAbstractButton>

namespace DESpot
{

//_________________________________________________________________________________________________

OutputButtonGroup::OutputButtonGroup(QObject* parent) : QButtonGroup(parent)
{
}

//_________________________________________________________________________________________________

OutputButtonGroup::~OutputButtonGroup(void)
{
}

//_________________________________________________________________________________________________

void OutputButtonGroup::check(QAbstractButton* button)
{
	//enable and check the given button
	button->setEnabled(true);
	button->setChecked(true);

	//disable all the other buttons
	QList<QAbstractButton*> buttonList = buttons();
	for(int iButton = 0; iButton < buttonList.size(); iButton++)
	{
		QAbstractButton* crtButton = buttonList.at(iButton);
		if (crtButton != button)
		{
			crtButton->setEnabled(false);
		}
	}
}

} // end of namespace DESpot
