/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "Workspace.h"
#include "DespotForm.h"
#include "MainForm.h"
#include "CommonDefinitions.h"

namespace DESpot
{

Workspace::Workspace(DespotForm* pForm)
{
	if (pForm == null)
		throw EX("Invalid form. Cannot create workspace")

	m_pForm = pForm;
}

Workspace::~Workspace(void)
{
	m_pForm = null;
}


DespotForm* Workspace::form()
{
	if (m_pForm == null)
		throw EX("Invalid form. Cannot return parent form")

	return m_pForm;
}

MainForm* Workspace::mainForm()
{
	if (m_pForm == null)
		throw EX("Invalid form. Cannot return main form")

	return m_pForm->mainForm();
}

} //end of namespace DESpot
