/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesAlgoChain.h"

namespace DESpot
{

//_________________________________________________________________________________________________

DesAlgoChain::DesAlgoChain(bool exitOnFirstFail) : m_exitOnFirstFail(exitOnFirstFail)
{
}

//_________________________________________________________________________________________________

DesAlgoChain::~DesAlgoChain(void)
{
}

//_________________________________________________________________________________________________

void DesAlgoChain::addAlgo(DesAlgo* algo)
{
	m_algoList.push_back(algo);
}

//_________________________________________________________________________________________________

bool DesAlgoChain::runAlgo()
{
	bool result = true;
	for(std::vector<DesAlgo*>::iterator it = m_algoList.begin(); it != m_algoList.end(); it++)
	{
		DesAlgo* algo = *it;

		//run the current algorithm. If it failed stop the chain and return 
		result &= algo->runAlgo();
		if (m_exitOnFirstFail && result == false)
		{
			return false;
		}
	}

	//all algorithms succeeded so the chain succeeded
	return result;
}

} //end of namespace DESpot
