/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "FlatProjIntegrityAlgo.h"
#include "DesFlatProject.h"


namespace DESpot
{

const std::wstring FlatProjIntegrityAlgo::cFlatProjIntegAlgoDesc = L"Flat Project Integrity Algorithm";

const std::wstring FlatProjIntegrityAlgo::cEmptySupervisorErr = L"The supervisor is empty";
const std::wstring FlatProjIntegrityAlgo::cEmptyPlantErr = L"The plant is empty";


FlatProjIntegrityAlgo::FlatProjIntegrityAlgo(bool runIncremental /*= true*/)
{
	m_runIncremental = runIncremental;
	m_description = cFlatProjIntegAlgoDesc;
}

//_________________________________________________________________________________________________

FlatProjIntegrityAlgo::FlatProjIntegrityAlgo(DesFlatProject* project, bool runIncremental /*= true*/) : 
	ProjIntegrityAlgo(project)
{
	m_runIncremental = runIncremental;
	m_description = cFlatProjIntegAlgoDesc;
}

//_________________________________________________________________________________________________

FlatProjIntegrityAlgo::~FlatProjIntegrityAlgo(void)
{
}

//_________________________________________________________________________________________________

DesFlatProject* FlatProjIntegrityAlgo::flatProject()
{
	DesFlatProject* flatProj = dynamic_cast<DesFlatProject*>(m_project);
	if (flatProj == null)
	{
		throw EX("Invalid project type. Cannot check project integrity");
	}

	return flatProj;
}

//_________________________________________________________________________________________________

//verifies that there is at least one supervisor DES in the project
bool FlatProjIntegrityAlgo::verifySupervisor()
{
	if (flatProject()->getSupDesCount() == 0)
	{
		addError(cEmptySupervisorErr);
		return false;
	}

	return true;
}

//_________________________________________________________________________________________________

//verifies that there is at least one plant DES in the project
bool FlatProjIntegrityAlgo::verifyPlant()
{
	if (flatProject()->getPlantDesCount() == 0)
	{
		addError(cEmptyPlantErr);
		return false;
	}

	return true;
}

//_________________________________________________________________________________________________

//Overridable called from the "run" method of the base implementation of the algorithm
bool FlatProjIntegrityAlgo::verifyIntegrity()
{
	//perform the general verification
	ProjIntegrityAlgo::verifyIntegrity();

	verifySupervisor();

	verifyPlant();

	//save the validity check in the subsystem's property for incremental checking
	m_project->getRootSubsys().setValid(isValid());

	return isValid();
}


} //end of namespace DESpot
