/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesStateEditorDlg.h"
#include <QMessageBox>

namespace DESpot
{

DesStateEditorDlg::DesStateEditorDlg(QWidget *parent) : QDialog(parent)
{
	setupUi(this);
	UpdateUI();
}

//_________________________________________________________________________________________________

DesStateEditorDlg::DesStateEditorDlg(const DesState& state, QWidget *parent) : QDialog(parent)
{
	setupUi(this);

	m_state = state;
	UpdateUI();
}

//_________________________________________________________________________________________________

DesStateEditorDlg::~DesStateEditorDlg(void)
{
}

//_________________________________________________________________________________________________

const DesState& DesStateEditorDlg::resultState() const
{
	return m_state;
}

//_________________________________________________________________________________________________
//Updates the dialog control with the values in the m_state
void DesStateEditorDlg::UpdateUI()
{
	m_stateNameEdit->setText(QString::fromStdWString(m_state.getName()));
	m_stateAliasEdit->setText(QString::fromStdWString(m_state.getAlias()));
	m_isInitialStateWidg->setChecked(m_state.isInit());
	m_isStateMarkedWidg->setChecked(m_state.isMarked());
}

void DesStateEditorDlg::setDefaultProps(bool initState, bool markedState)
{
	m_isInitialStateWidg->setChecked(initState);
	m_isStateMarkedWidg->setChecked(markedState);
}
//_________________________________________________________________________________________________

void DesStateEditorDlg::accept()
{
	//set the name of the state
	if (m_stateNameEdit->text().size() > 0)
	{
		try
		{
			m_state.setName(m_stateNameEdit->text().toStdWString());
		}
		catch(EXO)
		{
			display_ex();
			return;
		}
	}
	else
	{
		QMessageBox::critical(this, STR_DESPOT_ERROR, STR_STATE_NAME_MANDATORY_EX);
		
		return; //do not go any further until the user has provided a name for the state
	}

	//set the alias of the state
	if (m_stateAliasEdit->text().size() > 0)
	{
		try
		{
			//An alias was provided so set it
			m_state.setAlias(m_stateAliasEdit->text().toStdWString());
		}
		catch(EXO)
		{
			display_ex();
			return;
		}
	}
	else
	{
		m_state.setAlias(L"");
	}
	
	//set the init and marked properties of the state
	m_state.setInit(m_isInitialStateWidg->isChecked());
	m_state.setMarked(m_isStateMarkedWidg->isChecked());
	
	//close the dialog
	QDialog::accept();
}			

//_________________________________________________________________________________________________

void DesStateEditorDlg::reject()
{
	//close the dialog
	QDialog::reject();
}


} // end of namespace DESpot
