#ifndef TIRESTORAGE_H
#define TIRESTORAGE_H

/*


Tire structure for saving the des turple (s1,s2,s3,s4)
*/
#include <iostream>
#include <vector>
#include <stdio.h>
#include <stdlib.h>
#include <set>
#include <deque>
#include "Des.h"
#include "DesState.h"

#define TRIESEGSIZE 100000 //segment size for trie, used in found list.

//new add for Nonblocking
#define STATE_SEG 1000000 //store int for each state attachment
#define STATE_LIST_ATTACHMENT 10 // each state contain 10 state blog
#define STATE_LIST_ATTACHMENT_SEG 1000000// the stateblog for each state



using namespace std;


namespace DESpot
{


//---not change required------
class LinkedList{
public:
  LinkedList()
 {
  node=NULL;
  next=NULL;
}
  ~LinkedList()
  {
  }
  void addNode(int * innode) 
 {
  node=innode;
}
  int * getNode()
  {
  return node;
}
  void setNext(LinkedList * inNext)
{
  next=inNext;
}
  LinkedList * getNext()
{
  return next;
}

private:
  int * node;
  LinkedList * next;
};



//------------need change the State type define
class TrieNode{

public:
	//typedef int State;//---need to change
public:
  TrieNode()
{
  next=NULL;
}
  ~TrieNode()
{
}
  TrieNode * getNode(int index)
{
  return next+index;
}
  void addNode(TrieNode * node)
{
  next=node;
}
    
 void setState(void * state)//-------need change
 {
  next=(TrieNode *)state;

  
}
  
private:
  TrieNode * next;
};


////////////////////-----------Controblility algo////////////////////////////
class AlgoTrie{
public:
	 typedef std::vector<const Des*> DesSet;
	 typedef std::vector<short> SrcStateTuple;
private:
  int blocknumber;
  int id;
  TrieNode *root;
  long index;
  TrieNode * pin;  
  LinkedList * nodeSegList;


  DesSet &dictDES;
  short numDES;       //need outside define
public:
	AlgoTrie(DesSet &inDESSet):dictDES(inDESSet),numDES(dictDES.size())
  {
  blocknumber=0;
  index=0;
  pin=NULL;
  nodeSegList=NULL;
  root= allocateNode(1);
  id=0;
  }
  
  ~AlgoTrie() 
  {
  LinkedList * temp;
  temp=nodeSegList;
  while(nodeSegList){
    pin=(TrieNode*)(nodeSegList->getNode());
      delete [] pin;
    nodeSegList=nodeSegList->getNext();
  }
  delete temp;
  }
  
int insert(SrcStateTuple *sl)
{
  
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
     node->addNode(allocateNode(((int)dictDES[nDES]->getLastUsedStateId().id())+1));   //--------------dictDES[nDES] need to be define
    }
   node=node->getNode((*sl)[nDES]);
  }
  if(!node->getNode(0))
  {     
	  node->setState((DesState*)node); // need to be change
	  id++;
    return id-1;
  }else
  {
    return id-1; //state exists
  }

}




bool search(SrcStateTuple *sl)
{
   TrieNode *node=root;
 for(short nDES=0;nDES<numDES;nDES++)
 {
    if(!node->getNode(0))
	{
		return false;
    }
     node=node->getNode((*sl)[nDES]);
  }
  if((!node->getNode(0)))
  {
	  return false;
  }
  else
  {
	   return true;
  }
}

  
 
  //use a linkedlist to manage the memory block usage----Memory Block----(understand)
  TrieNode * allocateNode(int size)
  {
  TrieNode * ttn;
  if((index+size>= TRIESEGSIZE)||(!index)){//used up old seg, allocate new and set the link
	  ++blocknumber;
    LinkedList * temp=new LinkedList;
    pin = new TrieNode[TRIESEGSIZE];
    temp->setNext(nodeSegList);
    temp->addNode((int*)pin);//may change
    nodeSegList=temp;
    ttn=pin;
    pin=pin+size;
    
    index=size;
    return ttn;
  }
  ttn=pin;
  pin=pin+size;
  index+=size;
  return ttn;
}
  


int  getStateCount()
{
	return id;
}
  
int getBlockNumber()
{
	return blocknumber;
}
};


/////////////////////////////-----MeetSyn Algo----------------------------//////////////////////



class MeetSynTrie{

public:
	 typedef std::vector<const Des*> DesSet;
	 typedef std::vector<short> SrcStateTuple;
	 typedef std::vector<int*> TheArrayList;
public:
  TheArrayList m_array;
  int m_size;
  int blocknumber;
  int id;
  TrieNode *root;
  long index;
  TrieNode * pin;  
  LinkedList * nodeSegList;
  DesSet &dictDES;
  short numDES;       //need outside define

public:
  MeetSynTrie(DesSet &inDESSet):dictDES(inDESSet),numDES(dictDES.size()),m_size(100000)
  {

	  
  blocknumber=0;
  index=0;
  pin=NULL;
  nodeSegList=NULL;
  root= allocateNode(1);
  id=1;
  }
  
  ~MeetSynTrie() 
  {
  LinkedList * temp;
  temp=nodeSegList;
  while(nodeSegList){
    pin=(TrieNode*)(nodeSegList->getNode());
      delete [] pin;
    nodeSegList=nodeSegList->getNext();
  }
  delete temp;
  }
  

void insert(SrcStateTuple *sl) ///changed---still need change 
 {
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
      node->addNode(allocateNode(((int)dictDES[nDES]->getLastUsedStateId().id())+1)); 
    }
    node=node->getNode((*sl)[nDES]);
  }
  if(!node->getNode(0))
  { 
	  int* state=setID(id);
      node->setState(state); 
	  id++;
  }
}


bool search(SrcStateTuple *sl)
{
   TrieNode *node=root;
 for(short nDES=0;nDES<numDES;nDES++)
 {
    if(!node->getNode(0))
	{
		return false;
    }
     node=node->getNode((*sl)[nDES]);
  }
  if((!node->getNode(0)))
  {
	  return false;
  }
  else
  {
	   return true;
  }
}

  TrieNode * allocateNode(int size)
  {
  TrieNode * ttn;
  if((index+size>= TRIESEGSIZE)||(!index)){//used up old seg, allocate new and set the link
	  ++blocknumber;
    LinkedList * temp=new LinkedList;
    pin = new TrieNode[TRIESEGSIZE];
    temp->setNext(nodeSegList);
    temp->addNode((int*)pin);//may change
    nodeSegList=temp;
    ttn=pin;
    pin=pin+size;
    
    index=size;
    return ttn;
  }
  ttn=pin;
  pin=pin+size;
  index+=size;
  return ttn;
}
 
int* setID(int id)
{

	
 int arraylist_id=(id-1)%m_size;
 int item_id=(id-1)/m_size;
 if(item_id==0)
 {
	int* temp=new int[m_size];
	m_array.push_back(temp);
 }
 int* m_temp=m_array[arraylist_id];
  *(m_temp+item_id)=id;
  return (m_temp+item_id);
}
  

int getStateId(SrcStateTuple *sl)
{
   TrieNode *node=root;
 for(short nDES=0;nDES<numDES;nDES++)
 {
     node=node->getNode((*sl)[nDES]);
  }

 return *((int*)node->getNode(0));

}



};


























//-----------Nonblocking-------------------------------


class State
{
public:
State()
{
	counter=0;
	pin=NULL;
	temp=NULL;
}
~State()
{
	if(temp!=NULL)
	{
		free(temp);
	}
}

void initialize(int *start_address,int m_id)
{
	pin=start_address;
	id=m_id;
}

void setValue(int in_value)
{

    if(counter<STATE_LIST_ATTACHMENT)
	{
		pin[counter]=in_value;
	}
	else
	{
		if(counter%STATE_LIST_ATTACHMENT==0)
		{
			int blocknumber=counter/STATE_LIST_ATTACHMENT;
			temp=(int*)realloc(temp,blocknumber*STATE_LIST_ATTACHMENT*sizeof(int));
		}
		temp[counter-STATE_LIST_ATTACHMENT]=in_value;
	}
	counter++;
}

int getValue(int in_index)
{
	if(in_index<STATE_LIST_ATTACHMENT)
	{
		return *(pin+in_index);
	}
	else
	{
		return *(temp+in_index-STATE_LIST_ATTACHMENT);
	}
}

short returnUpperBound()
{
	return counter-1;
}
public:
int id;
private:
int *temp;
int *pin;
short counter;
};




class NonblockTrie
{
public:
	 typedef std::vector<const Des*> DesSet;
	 typedef std::vector<short> SrcStateTuple;
	 typedef std::deque<int> MarkedStateQue;
public:
  MarkedStateQue m_queue;
private:
  //original trie structure
  int blocknumber;
  int id;
  TrieNode *root;
  long index;
  TrieNode * pin;  
  LinkedList * nodeSegList;

  //for state info
  int aStateIndex;
  State *pinState;
  LinkedList* listhead;
  LinkedList* listback;
  //for state attachment int list info
  int alistIndex;
  int *pinList;
  LinkedList* statelisthead;
  LinkedList* statelistback;



 // DictDES *dictDES; // need outside define
  //--changed
  DesSet &dictDES;
  short numDES;       //need outside define
public:
	NonblockTrie(DesSet &inDESSet):dictDES(inDESSet),numDES(dictDES.size())
	{
		//original trie structure
		blocknumber=0;
        index=0;
        pin=NULL;
        nodeSegList=NULL;
        root= allocateNode(1);
        id=0;
       //for state info
        aStateIndex=0;
        listhead=NULL;
        listback=NULL;
       //for state attachment int list info
		alistIndex=0;
        statelisthead=NULL;
        statelistback=NULL;
	}
  ~NonblockTrie() 
  {
	  //original trie structure
	  destoryMemory();
     //need to delete
	  destoryAllStateList();
      destoryAllState();
  }

////////////////////////////////////////////////////--change one
void insert(SrcStateTuple *sl) ///changed------------------------for initial state enter
 {
  bool isMarked = true;
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
      node->addNode(allocateNode(((int)dictDES[nDES]->getStateCount())+1));  
    }
    node=node->getNode((*sl)[nDES]);
    isMarked&=dictDES[nDES]->getState((*sl)[nDES]).isMarked();
  }
  if(!node->getNode(0))
  { 
	State* state=createState();
	state->initialize(createStateList(),id);
	if(isMarked==true)
	{
		pushPending(id);//-----------------------------------------------------------need to define
	}
    node->setState(state); 
	id++;
  }
}


void insert(SrcStateTuple *sl,int m_id, bool useEvent) ///changed---still need change 
 {
  bool isMarked = true;
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
      node->addNode(allocateNode(((int)dictDES[nDES]->getStateCount())+1));  
    }
    node=node->getNode((*sl)[nDES]);
	isMarked&=dictDES[nDES]->getState((*sl)[nDES]).isMarked();
  }
  if(!node->getNode(0))
  { 
	State* state=createState();
	state->initialize(createStateList(),id);
	if(isMarked==true)
	{
		pushPending(id);//-----------------------------------------------------------need to define
	}
	if(useEvent==true)
	{
		state->setValue(m_id);
	}
    node->setState(state); 
	id++;
  }
}


int getStateId(SrcStateTuple *sl)
{
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
      node->addNode(allocateNode(((int)dictDES[nDES]->getStateCount())+1));  
    }
    node=node->getNode((*sl)[nDES]);
  }

  if((!node->getNode(0)))
  {
	  throw EX("find id error");
	  return 0;
  }
  else
  {
	  return ((State*)node->getNode(0))->id;
  }
}

bool search(SrcStateTuple *sl,int m_id,bool useEvent)
{
   TrieNode *node=root;
 for(short nDES=0;nDES<numDES;nDES++)
 {
    if(!node->getNode(0))
	{
		return false;
    }
     node=node->getNode((*sl)[nDES]);
  }
  if((!node->getNode(0)))
  {
	 // throw EX("search error");
	  return false;
  }
  else
  {
	  State* state=(State*)node->getNode(0);
	  if(useEvent==true)
	  {
		  state->setValue(m_id);
	  }
	   return true;
  }
}



void pushPending(int id)
{
	m_queue.push_back(id);
}




///////////////////////////////////////////////////

//----------------------------------Memory allocation-------------------------------------------//
private:
  TrieNode * allocateNode(int size)
  {
  TrieNode * ttn;
  if((index+size>= TRIESEGSIZE)||(!index)){//used up old seg, allocate new and set the link
	  ++blocknumber;
    LinkedList * temp=new LinkedList;
    pin = new TrieNode[TRIESEGSIZE];
    temp->setNext(nodeSegList);
    temp->addNode((int*)pin);//may change
    nodeSegList=temp;
    ttn=pin;
    pin=pin+size;
    
    index=size;
    return ttn;
  }
  ttn=pin;
  pin=pin+size;
  index+=size;
  return ttn;
}

public:
void destoryMemory()
{
	if(nodeSegList!=NULL)
	{
		TrieNode* m_pin=NULL;
	    LinkedList* curMTemp=nodeSegList;
		while(curMTemp!=NULL)
		{
			LinkedList* nxtMTemp=curMTemp->getNext();
            m_pin=(TrieNode*)(curMTemp->getNode());
		    delete [] m_pin;
		    delete curMTemp;
		    curMTemp=nxtMTemp;
		}
		nodeSegList=NULL;

	}
}

//---------------------------create ,access and delete the State---------------------------//NEW ADD NEED TEST
private:
State* createState()
{  
	if(!(aStateIndex%STATE_SEG))
	{
		LinkedList *newlist=new LinkedList;
		pinState=new State[STATE_SEG];
		aStateIndex=1;
		if(listhead==NULL)
		{
			listhead=newlist;
			listback=newlist;
            
		}
		else
		{
            listback->setNext(newlist);
            listback=newlist;
		}
		listback->addNode((int*)pinState);
        return pinState;
	}
	return &pinState[aStateIndex++];
}
public:
void destoryAllState()
{
	if(listhead!=NULL)
	{
		State* m_pinstate=NULL;
        LinkedList* curTemp=listhead;
		while(curTemp!=NULL)
		{
			LinkedList* nxtTemp=curTemp->getNext();
            m_pinstate=(State*)curTemp->getNode();
            delete []m_pinstate;
	        delete curTemp;
            curTemp=nxtTemp;
		}
		listhead=NULL;
	}

}
public:
State* getState(int index)
{
  int statelist_id=index/STATE_SEG;
  int pinloc_id=index%STATE_SEG;
  LinkedList* temp=listhead;
  
  if(statelist_id==0)
  {
    State *m_pin=(State*)(temp->getNode());
    return &m_pin[pinloc_id];
  }
  for(int i=1;i<=statelist_id;i++)
  {
    temp=temp->getNext();
  }
  State *m_pin=(State*)(temp->getNode());
  return &m_pin[pinloc_id];
}
//--------------------Create delete the statelist--------------------------------------------------//NEW ADD AND NEED TEST

private:
int* createStateList()
{
  if(!(alistIndex%STATE_LIST_ATTACHMENT_SEG))
  {
  LinkedList *newlist=new LinkedList;
   pinList=new int[STATE_LIST_ATTACHMENT_SEG];
   alistIndex=STATE_LIST_ATTACHMENT;//10
   if(statelisthead==NULL)
   {   
       statelistback=newlist;
       statelisthead=newlist;
       statelistback->setNext(NULL);
   }
   else
   {
      statelistback->setNext(newlist);
      statelistback=newlist;
      statelistback->addNode((int*)pinList);
   }
    return pinList;
  
  }
    int* temp=&pinList[alistIndex];
    alistIndex+=STATE_LIST_ATTACHMENT;
    return temp;
}
public:
void destoryAllStateList()
{
	if(statelisthead!=NULL)
	{
		int * m_pinstatelist=NULL;
        LinkedList* curListTemp=statelisthead;
        while(curListTemp!=NULL)
		{
			LinkedList* nxtListTemp=curListTemp->getNext();
            m_pinstatelist=(int*)curListTemp->getNode();
            delete []m_pinstatelist;
	        delete curListTemp;
            curListTemp=nxtListTemp;
		}
		statelisthead=NULL;
	}
}
//----------------------------
public:

int getStateCount()
{
	return id;
}
  
int getBlockNumber()
{
	return blocknumber;
	
}

};



//----------------------PN6 ALGO-------------------------------------






class IntPN6Trie
{
public:
	 typedef std::vector<const Des*> DesSet;
	 typedef std::vector<short> SrcStateTuple;
	 typedef std::deque<int> MarkedStateQue;
	 typedef std::set<int> SemiMarkedStateSet;
public:
  MarkedStateQue m_queue;
  SemiMarkedStateSet semi_set;
private:
  //original trie structure
  int blocknumber;
  int id;
  TrieNode *root;
  long index;
  TrieNode * pin;  
  LinkedList * nodeSegList;

  //for state info
  int aStateIndex;
  State *pinState;
  LinkedList* listhead;
  LinkedList* listback;
  //for state attachment int list info
  int alistIndex;
  int *pinList;
  LinkedList* statelisthead;
  LinkedList* statelistback;



 // DictDES *dictDES; // need outside define
  //--changed
  DesSet &dictDES;
  short numDES;       //need outside define
public:
	IntPN6Trie(DesSet &inDESSet):dictDES(inDESSet),numDES(dictDES.size())
	{
		//original trie structure
		blocknumber=0;
        index=0;
        pin=NULL;
        nodeSegList=NULL;
        root= allocateNode(1);
        id=0;
       //for state info
        aStateIndex=0;
        listhead=NULL;
        listback=NULL;
       //for state attachment int list info
		alistIndex=0;
        statelisthead=NULL;
        statelistback=NULL;
	}
  ~IntPN6Trie() 
  {
	  //original trie structure
	  destoryMemory();
     //need to delete
	  destoryAllStateList();
      destoryAllState();
  }

////////////////////////////////////////////////////--change one
void insert(SrcStateTuple *sl,int int_pos) ///changed------------------------for initial state enter
 {
  bool isMarked = true;
  bool isSemiMarked=true;
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
      node->addNode(allocateNode(((int)dictDES[nDES]->getStateCount())+1));  
    }
    node=node->getNode((*sl)[nDES]);
    isMarked&=dictDES[nDES]->getState((*sl)[nDES]).isMarked();
	if(nDES<=int_pos)
	{
		isSemiMarked&=dictDES[nDES]->getState((*sl)[nDES]).isMarked();
	}
  }
  if(!node->getNode(0))
  { 
	State* state=createState();
	state->initialize(createStateList(),id);
	if(isMarked==true)
	{
		pushPending(id);//-----------------------------------------------------------need to define
	}
	else if(isSemiMarked==true&&isMarked!=true)
	{
		pushSemiPending(id);
	}
    node->setState(state); 
	id++;
  }
}


void insert(SrcStateTuple *sl,int m_id, bool useEvent, int int_pos) ///changed---still need change 
 {
  bool isMarked = true;
  bool isSemiMarked=true;
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
      node->addNode(allocateNode(((int)dictDES[nDES]->getStateCount())+1));  
    }
    node=node->getNode((*sl)[nDES]);
	isMarked&=dictDES[nDES]->getState((*sl)[nDES]).isMarked();
    if(nDES<=int_pos)
	{
		isSemiMarked&=dictDES[nDES]->getState((*sl)[nDES]).isMarked();
	}

  }
  if(!node->getNode(0))
  { 
	State* state=createState();
	state->initialize(createStateList(),id);
	if(isMarked==true)
	{
		pushPending(id);//-----------------------------------------------------------need to define
	}
	else if(isSemiMarked==true&&isMarked!=true)
	{
		pushSemiPending(id);
	}
	if(useEvent==true)
	{
		state->setValue(m_id);
	}
    node->setState(state); 
	id++;
  }
}


int getStateId(SrcStateTuple *sl)
{
  TrieNode *node=root;
  for(short nDES=0;nDES<numDES;nDES++)
  {
    if(!node->getNode(0))
	{
      node->addNode(allocateNode(((int)dictDES[nDES]->getStateCount())+1));  
    }
    node=node->getNode((*sl)[nDES]);
  }

  if((!node->getNode(0)))
  {
	  throw EX("find id error");
	  return 0;
  }
  else
  {
	  return ((State*)node->getNode(0))->id;
  }
}

bool search(SrcStateTuple *sl,int m_id,bool useEvent)
{
   TrieNode *node=root;
 for(short nDES=0;nDES<numDES;nDES++)
 {
    if(!node->getNode(0))
	{
		return false;
    }
     node=node->getNode((*sl)[nDES]);
  }
  if((!node->getNode(0)))
  {
	 // throw EX("search error");
	  return false;
  }
  else
  {
	  State* state=(State*)node->getNode(0);
	  if(useEvent==true)
	  {
		  state->setValue(m_id);
	  }
	   return true;
  }
}



void pushPending(int id)
{
	m_queue.push_back(id);
}

void pushSemiPending(int id)
{
   semi_set.insert(id);
}


///////////////////////////////////////////////////

//----------------------------------Memory allocation-------------------------------------------//
private:
  TrieNode * allocateNode(int size)
  {
  TrieNode * ttn;
  if((index+size>= TRIESEGSIZE)||(!index)){//used up old seg, allocate new and set the link
	  ++blocknumber;
    LinkedList * temp=new LinkedList;
    pin = new TrieNode[TRIESEGSIZE];
    temp->setNext(nodeSegList);
    temp->addNode((int*)pin);//may change
    nodeSegList=temp;
    ttn=pin;
    pin=pin+size;
    
    index=size;
    return ttn;
  }
  ttn=pin;
  pin=pin+size;
  index+=size;
  return ttn;
}

public:
void destoryMemory()
{
	if(nodeSegList!=NULL)
	{
		TrieNode* m_pin=NULL;
	    LinkedList* curMTemp=nodeSegList;
		while(curMTemp!=NULL)
		{
			LinkedList* nxtMTemp=curMTemp->getNext();
            m_pin=(TrieNode*)(curMTemp->getNode());
		    delete [] m_pin;
		    delete curMTemp;
		    curMTemp=nxtMTemp;
		}
		nodeSegList=NULL;

	}
}

//---------------------------create ,access and delete the State---------------------------//NEW ADD NEED TEST
private:
State* createState()
{  
	if(!(aStateIndex%STATE_SEG))
	{
		LinkedList *newlist=new LinkedList;
		pinState=new State[STATE_SEG];
		aStateIndex=1;
		if(listhead==NULL)
		{
			listhead=newlist;
			listback=newlist;
            
		}
		else
		{
            listback->setNext(newlist);
            listback=newlist;
		}
		listback->addNode((int*)pinState);
        return pinState;
	}
	return &pinState[aStateIndex++];
}
public:
void destoryAllState()
{
	if(listhead!=NULL)
	{
		State* m_pinstate=NULL;
        LinkedList* curTemp=listhead;
		while(curTemp!=NULL)
		{
			LinkedList* nxtTemp=curTemp->getNext();
            m_pinstate=(State*)curTemp->getNode();
            delete []m_pinstate;
	        delete curTemp;
            curTemp=nxtTemp;
		}
		listhead=NULL;
	}

}
public:
State* getState(int index)
{
  int statelist_id=index/STATE_SEG;
  int pinloc_id=index%STATE_SEG;
  LinkedList* temp=listhead;
  
  if(statelist_id==0)
  {
    State *m_pin=(State*)(temp->getNode());
    return &m_pin[pinloc_id];
  }
  for(int i=1;i<=statelist_id;i++)
  {
    temp=temp->getNext();
  }
  State *m_pin=(State*)(temp->getNode());
  return &m_pin[pinloc_id];
}
//--------------------Create delete the statelist--------------------------------------------------//NEW ADD AND NEED TEST

private:
int* createStateList()
{
  if(!(alistIndex%STATE_LIST_ATTACHMENT_SEG))
  {
  LinkedList *newlist=new LinkedList;
   pinList=new int[STATE_LIST_ATTACHMENT_SEG];
   alistIndex=STATE_LIST_ATTACHMENT;//10
   if(statelisthead==NULL)
   {   
       statelistback=newlist;
       statelisthead=newlist;
       statelistback->setNext(NULL);
   }
   else
   {
      statelistback->setNext(newlist);
      statelistback=newlist;
      statelistback->addNode((int*)pinList);
   }
    return pinList;
  
  }
    int* temp=&pinList[alistIndex];
    alistIndex+=STATE_LIST_ATTACHMENT;
    return temp;
}
public:
void destoryAllStateList()
{
	if(statelisthead!=NULL)
	{
		int * m_pinstatelist=NULL;
        LinkedList* curListTemp=statelisthead;
        while(curListTemp!=NULL)
		{
			LinkedList* nxtListTemp=curListTemp->getNext();
            m_pinstatelist=(int*)curListTemp->getNode();
            delete []m_pinstatelist;
	        delete curListTemp;
            curListTemp=nxtListTemp;
		}
		statelisthead=NULL;
	}
}
//----------------------------
public:

int getStateCount()
{
	return id;
}
  
int getBlockNumber()
{
	return blocknumber;
	
}

};






















}
#endif