/*************************************************************************
  FILE:  BddHiscPubfunc.h
  DESCR: Header file for pubfunc.cpp 
  AUTH:  Raoguang Song
  Supervisor: Dr. Ryan Leduc
  DATE:  (C) Jan, 2006
*************************************************************************/
#ifndef ____BddHiscPUBFUNC_H____
#define ____BddHiscPUBFUNC_H____

#include <string>
#include "BddHiscType.h"
#include "BddHiscErrmsg.h"
#include <fdd.h>


using namespace std;


namespace BDDHISC
{


extern int giNumofBddNodes;

extern string str_trim(const string &str); 
extern string str_upper(const string &str); 
extern string str_lower(const string &str); 
extern string str_itos(int iInt);
extern string str_ltos(long long lLong);

extern string str_nocomment(const string & str);
extern int scp_err(const string & sErr, const int iErrCode);

extern string GetNameFromFile(const string & vsFile);
extern EVENTSUB SubLetterToValue(char cEventSub);
extern string SubValueToLetter(EVENTSUB vEventSub);

extern int IsInteger(const string &str);
extern int CompareInt(const void* pa, const void* pb);

extern void bddPrintStats(const bddStat &stat);
extern void SetBddPairs(bddPair *pPair, const bdd & bddOld, const bdd & bddNew);
extern int NumofSharedEvents(const int * pEventsArr_a, const int viNumofEvents_a,
         const int * pEventsArr_b, const int viNumofEvents_b);
extern void my_bdd_gbchandler(int pre, bddGbcStat *s);



} //end of namespace BDDHISC

#endif //____BddHiscPUBFUNC_H____
