/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
//#include "NonBlockingAlgo.h"
#include "MultiNonBlockingAlgo.h"
#include "DesHierProject.h"

namespace DESpot
{


	class LowSubsysNonBlockAlgo : public MultiNonBlockingAlgo
	{
		public:
			LowSubsysNonBlockAlgo(const DesSubsystem& subsystem);
			virtual ~LowSubsysNonBlockAlgo(void);

		public:
			virtual bool runAlgo();

			virtual const ErrorList& getErrorList();

			const DesSubsystem& getInputSubsystem() {return m_subsystem;}

			static const std::wstring cLowSubsysNonBlockingAlgoErr;

		protected:
			virtual void prepareRun();

		protected:			
			const DesSubsystem& m_subsystem;


		private:
			
			static const std::wstring cLowSubsysNonBlockAlgoDesc;
	};
}
