#ifndef SimStateModel_H
#define SimStateModel_H

#include <QAbstractItemModel>
#include "SimCompState.h"

namespace DESpot
{
class Node;

class SimStateModel : public QAbstractItemModel
{
	Q_OBJECT

public:
    SimStateModel(SimCompState::StateTuple gstate,QObject *parent = 0);
	SimStateModel(QObject *parent = 0);
    ~SimStateModel();

	SimCompState::StateTuple getGlobalState()
		{return globalState;}

    void setRootNode(Node *node);
	void setStateTuple(SimCompState::StateTuple gstate);

    QModelIndex index(int row, int column,
                      const QModelIndex &parent) const;
    QModelIndex parent(const QModelIndex &child) const;

    int rowCount(const QModelIndex &parent) const;
    int columnCount(const QModelIndex &parent) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role) const;
	Qt::ItemFlags flags(const QModelIndex &index) const;
	bool setData ( const QModelIndex & index, const QVariant & value, int role); 
	Node *nodeFromIndex(const QModelIndex &index) const;
	Node* getRootNode() const { return rootNode; }

	//by default readonly is false, the caller must explictly set it to readonly
	void setReadOnly(bool ro)
		{readOnly = ro;}

	void setShowViewCol(bool show) { showViewCol = show; }

private:

	bool isStateTupleInit();
	bool isStateTupleMarked();
    
	SimCompState::StateTuple globalState;
	bool readOnly;
    Node *rootNode;
    bool showViewCol;
};
}
#endif
