/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include "MultiNonBlockingAlgo.h"
#include "DesHierProject.h"

namespace DESpot
{
	
	class HighSubsysNonBlockAlgo : public MultiNonBlockingAlgo
	{
		public:
			HighSubsysNonBlockAlgo(DesHierProject& project);
			virtual ~HighSubsysNonBlockAlgo(void);

		public:
			virtual bool runAlgo();
			virtual const ErrorList& getErrorList();

			DesHierProject& getInputProject();

			static const std::wstring cHighSubsysNonBlockingAlgoErr;

		protected:
			virtual void prepareRun();
			virtual bool canUseTransition(short in_eventId);

		protected:			
			DesHierProject& m_project;

		private:
			static const std::wstring cHighSubsysNonBlockAlgoDesc;
	};
}
