/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc

	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering,
	Computing and Software Department,
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QTreeWidgetItem>
#include "ui_MainForm.h"
#include "CommonDefinitions.h"
#include "DespotTreeWidget.h"

class QWorkspace;

namespace DESpot
{
	class DespotForm;
	class ProjectEditor;
	class DesEditor;
	class Des;

	class OpenedWndUiPart: public QObject
	{
		Q_OBJECT

		public:
			OpenedWndUiPart(Ui::MainFormUI* pUiContainer);
			~OpenedWndUiPart(void);

		public:
			bool editorOpened(const QString& fileName, DesEditor*& out_desEditor);
			bool editorOpened(Des* des, DesEditor*& out_desEditor);
			bool editorOpened(const QString& fileName, ProjectEditor*& out_projEditor);

		public slots:
			void onFormOpened(DespotForm* form);
			void onFormClosed(DespotForm* form, bool& okToClose);

			void onShowCurrentWindow();
			void onCloseCurrentWindow();

		public:
			virtual bool eventFilter(QObject* target, QEvent* event);

		//Implementation Methods________________________
		private:
			void initUi(Ui::MainFormUI* pUiContainer);
			void setupConnections();
			void initOpenedWindowsWidget();
			QTreeWidgetItem* findItem(ProjectEditor* projEditor);

			void onWindowClosed(QMainWindow* window);

			DespotForm* getFormFromItem(QTreeWidgetItem* item);
			bool findItemFromWindow(QMainWindow* wnd, QTreeWidgetItem*& out_foundItem);

			bool removeItem(DespotForm* closingForm);
			bool closeOwnedForms(DespotForm* closingForm, QTreeWidgetItem* formItem);
			void removeItemFromAccessList(QTreeWidgetItem* item);

		private slots:
			void resizeWndListWidgHeaders(int width);

		private:
			DespotTreeWidget* m_wndListWidg;
			QPushButton*	  m_showCrtWndBtn;
			QPushButton*      m_closeCrtWndBtn;
			QTreeWidgetItem* m_mainFormItem;

			typedef std::map<DespotForm*, QTreeWidgetItem*> FormMap;
			typedef FormMap::iterator FormMapIt;
			FormMap m_openedFormsMap;

		//constants
		private:
			static const short cWndListWidgColumnCount;
			static const short cWndNameColumnIdx;
	};

} //end of namespace DESpot
