#ifndef SimEventModel_H
#define SimEventModel_H
#include <set>
#include <QAbstractTableModel>
#include <QMap>
#include "DesEvent.h"
#include "ProjectEvent.h"
#include "SubsystemEvent.h"
#include "InterfaceEvent.h"
#include "CommonDefinitions.h"


namespace DESpot
{

class SimEventNode
{
	public:
		// unsigned long id;  // from 0 <- use index into QList
		unsigned long step; // step
		const ProjectEvent* ev;
		QStringList	props;

		SimEventNode(unsigned long step, const ProjectEvent* ev);

	protected:
		//copied from eventviewerwidget.h
		static const QString cDefaultTypeLabel;
		static const QString cHighLevelTypeLabel;
		static const QString cLowLevelTypeLabel;
		static const QString cRequestTypeLabel;
		static const QString cAnswerTypeLabel;
		static const QString cLDataTypeLabel;
	private:
        QString getTypeLabel(EventType eventType);
};

class SimEventModel : public QAbstractTableModel
{
	Q_OBJECT

public:
    SimEventModel(QObject *parent = 0);

	void setOrder(bool ord)
		{ordered = ord;};
    
	//To display a sequence of events
	void setEventMap(const QMultiMap<unsigned long, const ProjectEvent*> map);
	//To display a set of event, i.e an eligible event set.
	void setEventMap(std::set<const ProjectEvent*> eventSet);
	void setEventMap(std::set<ProjectEvent*> eventSet);
	
	const ProjectEvent* getProjectEvent(int row);
	int eventCount()
		{return eventDataMap.count();}

	//re-implemented functions
    int rowCount(const QModelIndex &parent) const;
    int columnCount(const QModelIndex &parent) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role) const;

	// Edit operations
	void addEvents(QList<const ProjectEvent*> selEvents, int row);
	QMultiMap<unsigned long, const ProjectEvent*> &getEventMap()
	{return eventMap;}
	bool moveUp(QModelIndex index);
	bool moveDown(QModelIndex index);

	
public slots:
	void removeAllEvents();
	void removeEvents(QModelIndex indexes);

private:
	void popuplateEventDataMap();

private:
    QMultiMap<unsigned long, const ProjectEvent*> eventMap;
	QList<SimEventNode *> eventDataMap;
	bool ordered;

};

}
#endif
