/*************************************************************************
  FILE:  BddHiscProject.h
  DESCR: Header file of Project.cpp (Process project file (.prj))
  AUTH:  Raoguang Song
  Supervisor: Dr. Ryan Leduc
  DATE:  (C) Jan, 2006
*************************************************************************/
#ifndef _BddHiscPROJECT_H_
#define _BddHiscPROJECT_H_

#include <string>
#include <map>
#include "BddHiscType.h"
#include <fstream>
#include "BddHisc.h"

#include "DesProject.h"


using namespace std;


namespace BDDHISC
{

class CSub;
class CHighSub;
class CLowSub;

class CProject
{
public:
    CProject();
    virtual ~CProject();
    void InitPrj();
    void ClearPrj();
    int PrintPrj(ofstream& fout);
    int PrintPrjAll(string sFileName);

public:
 void LoadPrj(DESpot::DesProject& DESpotProj);

    int GenEventIndex(const EVENTSUB vEventSub, const int viSubIndex, 
                    const unsigned short vusiLocalEventIndex);
    EVENTSUB GenEventInfo(const int viEventIndex, EVENTSUB & vEventSub, 
                            int & viSubIndex, 
                            unsigned short & vusiLocalEventIndex);
    int AddPrjEvent(const string & vsEventName, const int viEventIndex,
                          EVENTSUB &vEventSub, int & viSubIndex);
    int SearchPrjEvent(const string & vsEventName);
    
    int GetNumofLows() const {return m_iNumofLows;};
    CSub* GetSub(const int iSubIndex);

    void SetErr(const string & vsErrMsg, const int viErrCode);
    void ClearErr();
    
    const char *GetErrMsg() const {return m_sErrMsg.data();};
    int GetErrCode() const {return m_iErrCode;};
    INVEVENTS & GetInvAllEventsMap() {return m_InvAllEventsMap;};

private:
    string GetSubFileFromPrjFile(const string & vsPrjFile, 
                                const string &vsSubDir);

private:
    string m_sPrjName;  //Project name
    int m_iNumofLows;   //Number of low-level subsystems
    
    CHighSub *m_pHighSub; //High-level pointer
    CLowSub **m_pLowSub; //Pointers for low-levels
    EVENTS m_AllEventsMap; //The map containing all the events in this project
                           //(Event Name (key), Event global index)
    INVEVENTS m_InvAllEventsMap; //The map containing all the events in this 
                                //project (Event global index (key), Event Name)

    string m_sErrMsg; //Error msg during processing this project
    int m_iErrCode; //Error code during processing this project
};

} //end of namespace BDDHISC

#endif //_BddHiscPROJECT_H_

