/*************************************************************************
  FILE:  BddHiscType.h
  DESCR: customized data types
  AUTH:  Raoguang Song
  Supervisor: Dr. Ryan Leduc
  DATE:  (C) Jan, 2006
*************************************************************************/
#ifndef _BddHiscTYPE_H_
#define _BddHiscTYPE_H_

#include <map>
#include <list>
#include <string>

using namespace std;

namespace BDDHISC
{
    #define MAX_LINE_LENGTH 513
    #define COMMENT_CHAR '#'
    #define MAX_STATES_IN_ONE_COMPONENT_DES 1024
    #define MAX_DOUBLE 1.7e308
    #define MAX_INT 2147483647
    #define ALL_EVENT 99
    #define ALL_EVENT_EXCEPT_LD 98
    #define MAX_PATH 255
    #define MAX_PATHLng 255
    #define DEBUG_TIME

    enum DESTYPE {PLANT_DES = 0, SPEC_DES = 1, INTERFACE_DES = 2};
    enum EVENTTYPE {CON_EVENT = 0, UNCON_EVENT = 1};

    // Modified to support Low-Data (LD) Events --H.I.
    enum EVENTSUB {H_EVENT = 0,
                   R_EVENT = 1,
                   A_EVENT = 2,
                   L_EVENT = 3,
                   LD_EVENT = 4};

    typedef map<string, int> STATES; //state name, index
    typedef map<int, string> INVSTATES; //state index, name

    typedef map<string, int> EVENTS; //event name, global index
    typedef map<int, string> INVEVENTS; //event global index, name

    typedef map<string, unsigned short> LOCALEVENTS; //event name, level-wise index
    typedef map<unsigned short, string> LOCALINVEVENTS;//event level-wise index,name

    typedef list<int> MARKINGLIST; //link list to save all the marker states index
    typedef map<int, int> TRANS; //source state index (key), target state index
} //end of namespace BDDHISC

#endif //_BddHiscTYPE_H_
