/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesTransSetTableWidget.h"
#include "Des.h"

namespace DESpot
{

const QString DesTransSetTableWidget::cSelfLoopTitle = "Self Loops";

DesTransSetTableWidget::DesTransSetTableWidget(QWidget* parent): DesDataTableWidget(parent)
{
}

DesTransSetTableWidget::~DesTransSetTableWidget(void)
{
}

//_________________________________________________________________________________________________

void DesTransSetTableWidget::loadData(Des* des, bool /*highLevelDes*/)
{
	//first clear all transitions
	setupWidget(m_tableColCount);

	//calculate and set the number of rows in the table necessary to load all transitions
	//first calculate the number of rows required for regular transitions, then add one for the 
	//self-loop separator and then add the number of rows required for the self-loops
	int rowCount = calculateRowCount(des->getTransCount(false), m_tableColCount) 
				   + 1 	//for the Self-Loop title
				   + calculateRowCount(des->getSelfTransCount(), m_tableColCount);

	setRowCount(rowCount);

	//load the transitions into the table
	int crtCol = 0;
	int crtRow = 0;
	Des::TransIteratorPtr transIt = des->createTransIterator(true);
	for(transIt->first(); transIt->notDone(); transIt->next())
	{
		const DesTransition& crtTrans = transIt->currentItem();
		 
		QString itemText = QString("(%1; %2; %3)").arg(QString::fromStdWString(crtTrans.fromState().getAlias()), 
													  QString::fromStdWString(crtTrans.event().getAlias()),
													  QString::fromStdWString(crtTrans.toState().getAlias()));

		QString itemTooltip = QString("(%1; %2; %3)").arg(QString::fromStdWString(crtTrans.fromState().getName()), 
											  QString::fromStdWString(crtTrans.event().getName()),
											  QString::fromStdWString(crtTrans.toState().getName()));

		
		QTableWidgetItem* crtTransItem = new QTableWidgetItem();
		crtTransItem->setText(itemText);
		crtTransItem->setToolTip(itemTooltip);		
		crtTransItem->setFlags(crtTransItem->flags() & ~Qt::ItemIsEditable);
		
		//add the item to the table
		setItem(crtRow, crtCol, crtTransItem);

		//increase the row and the column index
		calculateNextRowAndCol(crtRow, crtCol);
	}

	//add a separator title for Self Loops
	if (des->getSelfTransCount() > 0)
	{
		crtRow++;
		crtCol = m_tableColCount / 2;
		QTableWidgetItem* selfLoopTitleItem = new QTableWidgetItem();
		selfLoopTitleItem->setBackgroundColor(Qt::darkGray);
		selfLoopTitleItem->setTextColor(Qt::white);
		selfLoopTitleItem->setTextAlignment(Qt::AlignHCenter|Qt::AlignVCenter);
		QFont font = selfLoopTitleItem->font();
		font.setBold(true);
		selfLoopTitleItem->setFont(font);
		selfLoopTitleItem->setText(cSelfLoopTitle);
		setItem(crtRow, crtCol, selfLoopTitleItem);
		crtRow++;
		crtCol = 0;

		//add all self-loops
		Des::SelfTransIteratorPtr selfTransIt = des->createSelfTransIterator();
		for(selfTransIt->first(); selfTransIt->notDone(); selfTransIt->next())
		{
			const DesEvent& crtSelfTrans = selfTransIt->currentItem();
			 
			QString itemText = QString("( %1 )").arg(QString::fromStdWString(crtSelfTrans.getAlias()));
			QString itemTooltip = QString("( %1 )").arg(QString::fromStdWString(crtSelfTrans.getName()));
			
			QTableWidgetItem* crtSelfTransItem = new QTableWidgetItem();
			crtSelfTransItem->setText(itemText);
			crtSelfTransItem->setToolTip(itemTooltip);		
			crtSelfTransItem->setTextColor(Qt::blue);
					
			//add the item to the table
			setItem(crtRow, crtCol, crtSelfTransItem);

			//increase the row and the column index
			calculateNextRowAndCol(crtRow, crtCol);
		}
	}

	//now that all transitions have been added, auto-resize all rows
	autoResizeTableRows();
}

} //end of namespace DESpot
