/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ui_EventPool.h"
#include "DesProjectNotifications.h"
#include "DesNotifications.h"

namespace DESpot
{
	class DesProject;

	class EventPoolUiPart  : public QObject, private DesProjectNotifications, private DesNotifications
	{
		Q_OBJECT

		public:
			EventPoolUiPart(Ui::EventPoolUI* pUiContainer, DesProject* project);
			virtual ~EventPoolUiPart(void);

		private:			
			void initWidgets(Ui::EventPoolUI* pUiContainer);
			void setupConnections();
			
			void setupProjEventPoolWidg();
			void setupDesListWidget();

		private slots:
			void onAddProjectEventsToDes();
			void onEditProjectEvent();
			void onFindProjectEvent(const QString& eventName);

			void onDesSelected(int index);
			void onRemoveDesEvents();
			

		//Project Notifications
		private:		
			virtual void onProjectEventPoolChanged();
			virtual void onDesAdded(const Des& des, DesLevel /*desLevel*/) { addDes(des); }
			virtual void onDesAdded(const Des& des, DesLevel /*desLevel*/, const DesSubsystem& /*subsys*/){ addDes(des); }
			virtual void onDesAdded(const Des& des, const DesInterface& /*interf*/){ addDes(des); }
			virtual void onRemovingDes(const Des& des, DesLevel /*desLevel*/) { removeDes(des); }
			virtual void onRemovingDes(const Des& des, DesLevel /*desLevel*/, const DesSubsystem& /*subsys*/) { removeDes(des); }
			virtual void onRemovingDes(const Des& des, const DesInterface& /*interf*/) { removeDes(des); }
		
		//DES notifications
		private:
			//Notifications regarding the DES whose events are displaeyd by the event pool
			virtual void onEventAdded(const DesEvent& /*addedEvent*/) { m_desEventViewWidg->loadData(m_crtDes); }
			virtual void onEventChanged(const DesEvent& /*changedEvent*/){ m_desEventViewWidg->loadData(m_crtDes); }
			virtual void onEventRemoved(const DesEvent::ID& /*eventId*/){ if (!m_removingEvents) m_desEventViewWidg->loadData(m_crtDes); }

		//Implementation methods
		private:
			void addDes(const Des& des);
			void removeDes(const Des& des);

		private:
			DesProject* m_project;
			unsigned int m_projListnerId;
			
			Des*        m_crtDes;
			unsigned int m_desListnerId;

			bool m_removingEvents;

		private:
			ProjEventSetWidget* m_projEventViewWidg;
			QPushButton*		m_addProjEventsBtn;
			QPushButton*		m_editProjectEventBtn;
			QLineEdit*			m_findProjEventWidg;

			DesEventSetTableWidget*  m_desEventViewWidg;
			QPushButton*		m_removeDesEventsBtn;
			QComboBox*		    m_selDesWidg;
	};

} //end of namespace DESpot
