/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "Des.h"
#include "DesState.h"
#include "DesEvent.h"
#include "DesTransition.h"

namespace DESpot
{

	class DesNotifications
	{
		public:
			virtual void onNameChanged(const std::wstring& /*oldName*/, const std::wstring& /*newName*/) {};
			virtual void onFileNameChanged(const std::wstring& /*oldFileName*/, const std::wstring& /*newFileName*/) {};
			virtual void onTypeChanged(DesType /*oldType*/, DesType& /*newType*/) {};
			virtual void onIntegrityChanged() {};
			virtual void onReachabilityChanged() {};
			virtual void onNonBlockingChanged() {};

		public:
			virtual void onStateAdded(const DesState& /*addedState*/) {};
			virtual void onStateChanged(const DesState& /*changedState*/) {};
			virtual void onRemovingState(const DesState& /*state*/) {};
			virtual void onStateRemoved(const DesState::ID& /*stateId*/) {};

		public:
			virtual void onEventAdded(const DesEvent& /*addedEvent*/) {};
			virtual void onEventChanged(const DesEvent& /*changedEvent*/) {};
			virtual void onRemovingEvent(const DesEvent& /*event*/) {};
			virtual void onEventRemoved(const DesEvent::ID& /*eventId*/) {};

		public:
			virtual void onTransitionAdded(const DesTransition& /*addedTrans*/) {};
			virtual void onGlobalSelfTransitionAdded(const DesEvent& /*selfTransEvent*/) {};
			virtual void onTransitionChanged(const DesTransition& /*trans*/, const DesTransition& /*change*/) {};
			virtual void onRemovingTransition(const DesTransition& /*removedTrans*/) {};
			virtual void onTransitionRemoved(const DesTransition& /*removedTrans*/) {};
			virtual void onRemovingSelfTransition(const DesEvent& /*selfTransEvent*/) {};
			virtual void onSelfTransitionRemoved(const DesEvent& /*selfTransEvent*/) {};
	};


} //end of namspace DESpot
