/*	Author:		Adam Brousseau
	Supervisor: Dr. Ryan Leduc
*/

#include <QMessageBox>
#include "HelpPrint.h"
#include "CommonDefinitions.h"


namespace DESpot
{

HelpPrint::HelpPrint(QWidget* parent /*= null*/) : QDialog(parent)
{
	setupUi(this);

	check_compact->setVisible(false);

	connect(radio_printAll, SIGNAL(toggled(bool)), this, SLOT(hideCheckbox()));
	connect(pButton, SIGNAL(clicked()), this, SLOT(accept()));
	connect(cButton, SIGNAL(clicked()), this, SLOT(reject()));
}

//_________________________________________________________________________________________________

HelpPrint::~HelpPrint(void)
{
}

//_________________________________________________________________________________________________

bool HelpPrint::printAll()
{
	return radio_printAll->isChecked();
}

//_________________________________________________________________________________________________

bool HelpPrint::printImages()
{
	return check_images->isChecked();
}

//_________________________________________________________________________________________________

void HelpPrint::hideCheckbox()
{
	if(check_compact->isVisible()){
		check_compact->setVisible(false);
	}else{
		check_compact->setVisible(true);
	}
}

//_________________________________________________________________________________________________

bool HelpPrint::compactForm()
{
	return check_compact->isChecked();
}

} //end of namespace DESpot
