/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "IntegrityAlgo.h"

namespace DESpot
{

const std::wstring IntegrityAlgo::cNotCheckedErr = L"Integrity not checked";

IntegrityAlgo::IntegrityAlgo(void)
{
	addError(cNotCheckedErr);
}

IntegrityAlgo::~IntegrityAlgo(void)
{
}

//_________________________________________________________________________________________________

//Returns true if the structure we're checking the integrity of is valid
bool IntegrityAlgo::isValid()
{
	return m_errorList.empty();
}

//_________________________________________________________________________________________________

void IntegrityAlgo::overrideIsValid()
{
	m_errorList.clear();
}


//_________________________________________________________________________________________________

bool IntegrityAlgo::isNameDuplicated(NameMap& nameMap, const std::wstring& name, bool& o_alreadyTested)
{
	NameIt nameIt = nameMap.find(name);
	if ( nameIt != nameMap.end())
	{
		//name is already in the map thus it is not unique
		o_alreadyTested = nameIt->second;
		if (o_alreadyTested == false)
		{
			//mark it as reported
			nameIt->second = true;
		}

		return true;
	}
	else
	{
		//mark the name as found; false means it was NOT found duplicated
		nameMap[name] = false;
		return false;
	}
}

//_________________________________________________________________________________________________

//prepare the data for running the algorithm
void IntegrityAlgo::prepareRun()
{
	m_errorList.clear();
	m_warningList.clear();
	startAlgo();
}

//_________________________________________________________________________________________________

//Runs the algorithm and returns true if DES is consistent
bool IntegrityAlgo::runAlgo()
{
	ProgressUpdater updater(m_progress);

	prepareRun();

	bool result = verifyIntegrity();

	return result;
}

} // namespace DESpot

