/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QObject>
#include <QMenu>
#include "ui_DesEditor.h"
#include "DesState.h"
#include "DesNotifications.h"

class QGroupBox;
class QTreeWidget;

namespace DESpot
{
	class DespotTreeWidget;
	class DesWorkspace;
	class Des;
	class StateQuickLookUiPart;
	class TransRecorder;

	class StateEditorUiPart : public QObject, private DesNotifications
	{
		Q_OBJECT	

		public:
			StateEditorUiPart(DesWorkspace* pWorkspace, Ui::DesEditorUI* pUiContainer, 
							  Des* pDes, StateQuickLookUiPart* pStateQuickLookUiPart, 
							  TransRecorder& transRecorder);
			virtual ~StateEditorUiPart(void);

		public:
			void clearSelection();
			
			//returns the context menu for this UI Part
			QMenu& getContextMenu();

		//Signals_______________________________________
		signals:
			void onCurrentStateChanged(const DesState& selectedState);

		//Slots_________________________________________
		private slots:			
			void onUserChangedStateName(const DesState& changedState, const std::wstring& newName);
			void onUserChangedStateAlias(const DesState& changedState, const std::wstring& newAlias);
			void onUserChangedStateInit(const DesState& changedState, bool newInit);
			void onUserChangedStateMarking(const DesState& changedState, bool newMarking);
			
		//Des Notification Handlers_______________________
		private:
			virtual void onReachabilityChanged();
			
			//Notifications received from the contained DES when the its states change
			virtual void onStateAdded(const DesState& addedState);
			virtual void onStateChanged(const DesState& changedState);
			virtual void onRemovingState(const DesState& state);

			virtual void onTransitionAdded(const DesTransition& /*addedTrans*/);
			virtual void onTransitionChanged(const DesTransition& /*trans*/, const DesTransition& /*change*/);
			virtual void onTransitionRemoved(const DesTransition& /*removedTrans*/);

		//Implementation Methods________________________
		private:
			void initStateViewWidget();
			void setupConnections(DesWorkspace* pWorkspace);

		private:
			StateViewerWidget* m_pStateViewWidg;

			QMenu m_stateEditorContextMenu;

			//The Des that owns the state displayed in this UI part
			Des* m_pDes;
			unsigned int m_desListnerId;

			StateQuickLookUiPart* m_pStateQuickLookUiPart;
};

} //end of namespace DESpot
