/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QHeaderView>

#include "CommonDefinitions.h"
#include "DesEventSetTableWidget.h"
#include "Des.h"


namespace DESpot
{

const QString DesEventSetTableWidget::cHighEventDesc = "high";
const QString DesEventSetTableWidget::cLowEventDesc = "low";
const QString DesEventSetTableWidget::cReqEventDesc = "request";
const QString DesEventSetTableWidget::cAnsEventDesc = "answer";
const QString DesEventSetTableWidget::cLdEventDesc = "low data";
const QString DesEventSetTableWidget::cEventDesc = "events";
const QString DesEventSetTableWidget::cCtrlEventDesc = "controllable";
const QString DesEventSetTableWidget::cUnctrlEventDesc = "uncontrollable";


//_________________________________________________________________________________________________

DesEventSetTableWidget::DesEventSetTableWidget(QWidget* parent): DesDataTableWidget(parent)
{
}

//_________________________________________________________________________________________________

DesEventSetTableWidget::~DesEventSetTableWidget(void)
{
}

//_________________________________________________________________________________________________

void DesEventSetTableWidget::loadData(Des* des, bool highLevelDes)
{
	//first clear all events
	setupWidget(m_tableColCount);

	//calculate and set the number of rows in the table necessary to load all events
	setRowCount(calculateRowCount(des->getEventCount(), m_tableColCount));

	//load the event into the table
	int crtCol = 0;
	int crtRow = 0;
	Des::EventIteratorPtr eventIt = des->createEventIterator();
	for(eventIt->first(); eventIt->notDone(); eventIt->next())
	{
		const DesEvent& crtEvent = eventIt->currentItem();
		 
		QString itemText = QString("%1 (%2)").arg(QString::fromStdWString(crtEvent.getName()), 
												   QString::fromStdWString(crtEvent.getAlias()));

		QString eventTypeDesc = getEventTypeDesc(crtEvent, highLevelDes);
		eventTypeDesc.data()[0].toUpper(); //capitalize the description

		QString itemTooltip = QString("%1\n\nType:\t%2\nControllable:\t%3\nUsed:\t%4").arg(
										itemText,
										eventTypeDesc,
										crtEvent.isControllable() ? cYes : cNo,
										crtEvent.isUsed() ? cYes : cNo);
		
		QTableWidgetItem* crtEventItem = new QTableWidgetItem();
		crtEventItem->setText(itemText);
		crtEventItem->setToolTip(itemTooltip);		
		crtEventItem->setData(Qt::UserRole, static_cast<unsigned long long>(crtEvent.getId()));
		crtEventItem->setFlags(crtEventItem->flags() & ~Qt::ItemIsEditable);

		//make the text blue if the current state is the initial state
		if (crtEvent.isControllable())
		{
			crtEventItem->setTextColor(Qt::blue);
		}
		
		//add the item to the table
		setItem(crtRow, crtCol, crtEventItem);

		//increase the row and the column index
		calculateNextRowAndCol(crtRow, crtCol);
	}

	//now that all events have been added, auto-resize all rows
	autoResizeTableRows();
}

//_________________________________________________________________________________________________

QString DesEventSetTableWidget::getEventTypeDesc(const DesEvent& event, bool highLevelDes /*= false*/)
{
	switch(event.getType())
	{
		case eDefaultEvent:
			return (highLevelDes) ? cHighEventDesc : cLowEventDesc;

		case eRequestEvent:
			return cReqEventDesc;

		case eAnswerEvent:
			return cAnsEventDesc;

		case eLDataEvent:
			return cLdEventDesc;

		default:
			assert(false);
			return "Unknown";
	}
}
} //end of namespace DESpot
