/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "ProjSummaryUiPart.h"
#include "DesProject.h"
#include "CommonDefinitions.h"

namespace DESpot
{

ProjSummaryUiPart::ProjSummaryUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesProject* pProject):
	m_pProject(pProject)
{
	initWidgets(pUiContainer);

	//subscribe to the project's notifications
	m_projListnerId = m_pProject->subscribe(this);
}

//_________________________________________________________________________________________________

ProjSummaryUiPart::ProjSummaryUiPart(Ui::HierProjectEditorUI* pUiContainer, DesProject* pProject):
	m_pProject(pProject)
{
	initWidgets(pUiContainer);

	//subscribe to the project's notifications
	m_projListnerId = m_pProject->subscribe(this);
}

//_________________________________________________________________________________________________

ProjSummaryUiPart::~ProjSummaryUiPart(void)
{
	m_pProject->unsubscribe(m_projListnerId);
}

//_________________________________________________________________________________________________
//Initializes the widgets from either the flat project editor or the hierhical project editor
//Called from the two constructors
template<class T> 
void ProjSummaryUiPart::initWidgets(T* pUiContainer)
{
	m_projNameDisplay = pUiContainer->m_projNameDisplay;
	m_projTypeDisplay = pUiContainer->m_projTypeDisplay;
	m_projLocationDisplay = pUiContainer->m_projLocationDisplay;

	m_projStatusNotChckLabel = pUiContainer->m_projStatusNotChckLabel;
	m_projStatusValidWidg = pUiContainer->m_projStatusValidWidg;
	m_projStatusInvalidWidg = pUiContainer->m_projStatusInvalidWidg;
	
	m_statusRadioBtnGroup = new OutputButtonGroup(this);
	m_statusRadioBtnGroup->addButton(m_projStatusValidWidg);
	m_statusRadioBtnGroup->addButton(m_projStatusInvalidWidg);

	m_projStatusVerifiedLabel = pUiContainer->m_projStatusVerifiedLabel;
	m_projStatusDateStampWidg = pUiContainer->m_projStatusDateStampWidg;

	m_projStatusSpacer1 = pUiContainer->m_projStatusSpacer1;
	m_projStatusSpacer2	= pUiContainer->m_projStatusSpacer2;
	m_projStatusSpacer3	= pUiContainer->m_projStatusSpacer3;
	m_projStatusSpacer4	= pUiContainer->m_projStatusSpacer4;

	m_gridLayout = pUiContainer->gridLayout;
}

//_________________________________________________________________________________________________

void ProjSummaryUiPart::updateUi()
{
	updateProjectPropsUi();
	updateProjectStatusUi();
}

//_________________________________________________________________________________________________

void ProjSummaryUiPart::updateProjectPropsUi()
{
	//update the name of the project
	m_projNameDisplay->setText(QString::fromStdWString(m_pProject->getName()));

	//update the type of the project
	switch(m_pProject->getType())
	{
		case eFlatProject:
			m_projTypeDisplay->setText(STR_FLAT_PROJECT);
			break;

		case eHierProject:
			m_projTypeDisplay->setText(STR_HIER_PROJECT);
			break;

		default:
			assert(false); //unknown type leave empty
	}

	//update the location of the project
	m_projLocationDisplay->setText(QString::fromStdWString(m_pProject->getFileName()));
}

//_________________________________________________________________________________________________

void ProjSummaryUiPart::updateProjectStatusUi()
{
	Integrity projInteg = m_pProject->getIntegrity();

	//either show the "not verified" label or show the verification status widgets depending
	//whether the project has been verified or not
	bool showIntegProp = (projInteg != eIntegNotVerified);
	m_projStatusNotChckLabel->setVisible(!showIntegProp);	
	
	//show (or hide) and update the status of the verification widgets
	m_projStatusValidWidg->setVisible(showIntegProp);
	m_projStatusInvalidWidg->setVisible(showIntegProp);
	m_projStatusSpacer1->setVisible(showIntegProp);
	m_projStatusSpacer2->setVisible(showIntegProp);
	m_projStatusSpacer3->setVisible(showIntegProp);
	m_projStatusSpacer4->setVisible(showIntegProp);
	m_projStatusVerifiedLabel->setVisible(showIntegProp);
	m_projStatusDateStampWidg->setVisible(showIntegProp);

	if (projInteg == eIntegYes)
	{
		m_statusRadioBtnGroup->check(m_projStatusValidWidg);
	}
	else
	{
		m_statusRadioBtnGroup->check(m_projStatusInvalidWidg);
	}
	
	//update the date of verification
	if (showIntegProp)
	{
		QString     integStamp = QString::fromStdWString(m_pProject->getIntegrityStamp());
		QDateTime   integDateTime = QDateTime::fromString(integStamp);
		m_projStatusDateStampWidg->setDateTime(integDateTime);
	}

	m_gridLayout->invalidate();
}

//_________________________________________________________________________________________________

void ProjSummaryUiPart::onIntegStatusChanged()
{
	updateProjectStatusUi();
}

//_________________________________________________________________________________________________

// Ticket # 54 - added this code to update porject properties
void ProjSummaryUiPart::onProjectNameChanged(const std::wstring& /*newName*/, const std::wstring& /*oldName*/)
{
	updateProjectPropsUi();
}

} //end of namespace DESpot
