/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ui_FlatProjectEditor.h"
#include "ui_HierProjectEditor.h"
#include "DesProjectNotifications.h"
#include "OutputButtonGroup.h"

namespace DESpot
{
	class DesProject;
	

	class ProjSummaryUiPart: public QObject, private DesProjectNotifications
	{
		//Constructors are protected so the proper derived class is created. This is only a base-class
		protected:
			ProjSummaryUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesProject* pProject);
			ProjSummaryUiPart(Ui::HierProjectEditorUI* pUiContainer, DesProject* pProject);
		
		public:
			virtual ~ProjSummaryUiPart(void);
	
		protected:			
			//Initializes the widgets from either the flat project editor or the hierhical project editor
			//Called from the two constructors
			template<class T> 
			void initWidgets(T* pUiContainer);

			//methods that update the UI from the project data
			void updateUi();
			void updateProjectPropsUi();
			void updateProjectStatusUi();

		//Project notifications
		private:
			virtual void onIntegStatusChanged();
			virtual void onProjectNameChanged(const std::wstring& /*newName*/, const std::wstring& /*oldName*/);

		//Data
		protected:
			//The project that owns the components displayed in this UI Part
			DesProject*   m_pProject;
			unsigned int m_projListnerId;

		//Widgets
		protected:
			QLabel* m_projNameDisplay;
			QLabel* m_projTypeDisplay;
			QLabel* m_projLocationDisplay;

			OutputButtonGroup* m_statusRadioBtnGroup;
			QLabel* m_projStatusNotChckLabel;
			QRadioButton* m_projStatusValidWidg;
			QRadioButton* m_projStatusInvalidWidg;
			QLabel* m_projStatusVerifiedLabel;
			QDateTimeEdit* m_projStatusDateStampWidg;		

			QLabel* m_projStatusSpacer1;
			QLabel* m_projStatusSpacer2;
			QLabel* m_projStatusSpacer3;
			QLabel* m_projStatusSpacer4;

			QGridLayout* m_gridLayout;
	};

} //end of namespace DESpot

