/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "FlatProjStructureUiPart.h"
#include "CommonDefinitions.h"
#include "DesFlatProject.h"

namespace DESpot
{

FlatProjStructureUiPart::FlatProjStructureUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesFlatProject* pProject):
	ProjStructureUiPart(pProject)
{
	initWidgets(pUiContainer);

	setupProjectStructWidget();	

	setupConnections();

	loadProjectStruct();
}

//_________________________________________________________________________________________________

FlatProjStructureUiPart::~FlatProjStructureUiPart(void)
{
}

//_________________________________________________________________________________________________

DesFlatProject& FlatProjStructureUiPart::project()
{
	return dynamic_cast<DesFlatProject&>(*m_pProject);	
}

//_________________________________________________________________________________________________

void FlatProjStructureUiPart::loadProjectStruct()
{
	addSupDesToUiItem();
	addPlantDesToUiItem();
}

//_________________________________________________________________________________________________

void FlatProjStructureUiPart::addSupDesToUiItem()
{							  
	DesProject::DesIteratorPtr desIt = m_pProject->createDesIterator(eSupervisorDes);
	ProjStructureUiPart::addSupDesToUiItem(m_flatStructSupUiItem, desIt);
}

//_________________________________________________________________________________________________

void FlatProjStructureUiPart::addPlantDesToUiItem()
{
	DesProject::DesIteratorPtr desIt = m_pProject->createDesIterator(ePlantDes);
	ProjStructureUiPart::addPlantDesToUiItem(m_flatStructPlantUiItem, desIt);
}

} //end of namespace DESpot
