/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDNonRepFTAlgoNonblocking.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot
{
BDDNonRepFTAlgoNonblocking::BDDNonRepFTAlgoNonblocking(const DesProject& currentProject, QList<QString>& faultSet ,int M, int N , QMultiMap<int,QString>& faultSets) : NonRepFTAlgo(currentProject, faultSet , M , N , faultSets), m_isBDDNonRepFTNonblocking(false)
{
}
//____________________________________________________________________________________________________________________________________	
BDDNonRepFTAlgoNonblocking::~BDDNonRepFTAlgoNonblocking()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo BDDNonRepFTAlgoNonblocking::runBDDFTNonblockingAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{	
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	if (m_N < m_M)
	{
		NonRepFTAlgo::constructGNF();
		NonRepFTAlgo::addGNF();
	}
	if (m_N > 0)
	{
		NonRepFTAlgo::constructGFi();
	}
	return BDDNonRepFTAlgoNonblocking::verifyBDDFTNonblocking();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo BDDNonRepFTAlgoNonblocking::verifyBDDFTNonblocking()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_NBChkInfo  checkInfo("Project passes Nonblocking Check");
      		tmp = BddSdCheckNB((DesProject&) *m_flatDummyProject, checkInfo);
     		if (checkInfo.m_chkPassed)
			m_isBDDNonRepFTNonblocking = true;
		else
			m_isBDDNonRepFTNonblocking = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDNonRepFTAlgoNonblocking::isBDDNonRepFTNonblocking() const
{return m_isBDDNonRepFTNonblocking;}
}



